/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic.output;

import com.lambdaworks.redis.dynamic.support.TypeInformation;
import com.lambdaworks.redis.internal.LettuceAssert;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OutputSelector {
    private final TypeInformation<?> typeInformation;
    private final boolean key;
    private final boolean value;
    private final Map<String, TypeInformation<?>> typeVariables;

    public OutputSelector(TypeInformation<?> typeInformation) {
        this(typeInformation, false, false, Collections.emptyMap());
    }

    public OutputSelector(TypeInformation<?> typeInformation, boolean key, boolean value, Map<String, TypeInformation<?>> typeVariables) {
        LettuceAssert.notNull(typeInformation, "Result TypeInformation must not be null");
        LettuceAssert.notNull(typeVariables, "Map of type variables must not be null");
        this.typeInformation = typeInformation;
        this.key = key;
        this.value = value;
        this.typeVariables = Collections.unmodifiableMap(new HashMap(typeVariables));
    }

    public boolean containsTypeVariable(String typeVariableName) {
        return this.typeVariables.containsKey(typeVariableName);
    }

    public TypeInformation<?> getTypeVariable(String typeInformation) {
        return this.typeVariables.get(typeInformation);
    }

    public TypeInformation<?> getTypeInformation() {
        return this.typeInformation;
    }

    public Map<String, TypeInformation<?>> getTypeVariables() {
        return Collections.unmodifiableMap(this.typeVariables);
    }

    public boolean isKey() {
        return this.key;
    }

    public boolean isValue() {
        return this.value;
    }
}

