/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic.output;

import com.lambdaworks.redis.dynamic.output.CommandOutputFactory;
import com.lambdaworks.redis.dynamic.output.CommandOutputFactoryResolver;
import com.lambdaworks.redis.dynamic.output.CommandOutputResolverSupport;
import com.lambdaworks.redis.dynamic.output.OutputRegistry;
import com.lambdaworks.redis.dynamic.output.OutputSelector;
import com.lambdaworks.redis.dynamic.output.OutputType;
import com.lambdaworks.redis.dynamic.support.ClassTypeInformation;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.output.CommandOutput;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OutputRegistryCommandOutputFactoryResolver
extends CommandOutputResolverSupport
implements CommandOutputFactoryResolver {
    private static final ClassTypeInformation<CommandOutput> COMMAND_OUTPUT = ClassTypeInformation.from(CommandOutput.class);
    private final OutputRegistry outputRegistry;

    public OutputRegistryCommandOutputFactoryResolver(OutputRegistry outputRegistry) {
        LettuceAssert.notNull(outputRegistry, "OutputRegistry must not be null");
        this.outputRegistry = outputRegistry;
    }

    @Override
    public CommandOutputFactory resolveCommandOutput(OutputSelector outputSelector) {
        Map<OutputType, CommandOutputFactory> registry = this.outputRegistry.getRegistry();
        Set<OutputType> outputTypes = registry.keySet().stream().filter(outputType -> !outputType.isStreaming()).collect(Collectors.toSet());
        List<OutputType> candidates = this.getCandidates(outputTypes, outputSelector);
        if (candidates.isEmpty()) {
            return null;
        }
        return registry.get(candidates.get(0));
    }

    @Override
    public CommandOutputFactory resolveStreamingCommandOutput(OutputSelector outputSelector) {
        Map<OutputType, CommandOutputFactory> registry = this.outputRegistry.getRegistry();
        Set<OutputType> outputTypes = registry.keySet().stream().filter(OutputType::isStreaming).collect(Collectors.toSet());
        List<OutputType> candidates = this.getCandidates(outputTypes, outputSelector);
        if (candidates.isEmpty()) {
            return null;
        }
        return registry.get(candidates.get(0));
    }

    private List<OutputType> getCandidates(Collection<OutputType> outputTypes, OutputSelector outputSelector) {
        return outputTypes.stream().filter(outputType -> {
            if (COMMAND_OUTPUT.getType().isAssignableFrom(outputSelector.getTypeInformation().getType()) && outputSelector.getTypeInformation().getType().isAssignableFrom(outputType.getCommandOutputClass())) {
                return true;
            }
            return this.isAssignableFrom(outputSelector, (OutputType)outputType);
        }).collect(Collectors.toList());
    }
}

