/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic.output;

import com.lambdaworks.redis.dynamic.output.CommandOutputFactory;
import com.lambdaworks.redis.dynamic.output.OutputType;
import com.lambdaworks.redis.dynamic.output.VoidOutput;
import com.lambdaworks.redis.dynamic.support.ClassTypeInformation;
import com.lambdaworks.redis.dynamic.support.TypeInformation;
import com.lambdaworks.redis.dynamic.support.TypeVariableTypeInformation;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.output.ArrayOutput;
import com.lambdaworks.redis.output.BooleanListOutput;
import com.lambdaworks.redis.output.BooleanOutput;
import com.lambdaworks.redis.output.ByteArrayOutput;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.output.DoubleOutput;
import com.lambdaworks.redis.output.GeoCoordinatesListOutput;
import com.lambdaworks.redis.output.GeoCoordinatesValueListOutput;
import com.lambdaworks.redis.output.IntegerOutput;
import com.lambdaworks.redis.output.KeyListOutput;
import com.lambdaworks.redis.output.KeyOutput;
import com.lambdaworks.redis.output.ListOfMapsOutput;
import com.lambdaworks.redis.output.MapOutput;
import com.lambdaworks.redis.output.ScoredValueListOutput;
import com.lambdaworks.redis.output.StreamingOutput;
import com.lambdaworks.redis.output.StringListOutput;
import com.lambdaworks.redis.output.StringValueListOutput;
import com.lambdaworks.redis.output.ValueListOutput;
import com.lambdaworks.redis.output.ValueOutput;
import com.lambdaworks.redis.output.ValueSetOutput;
import com.lambdaworks.redis.output.ValueValueListOutput;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OutputRegistry {
    private static final Map<OutputType, CommandOutputFactory> BUILTIN = new LinkedHashMap<OutputType, CommandOutputFactory>();
    private final Map<OutputType, CommandOutputFactory> registry = new LinkedHashMap<OutputType, CommandOutputFactory>();

    public OutputRegistry() {
        this(true);
    }

    public OutputRegistry(boolean registerBuiltin) {
        if (registerBuiltin) {
            this.registry.putAll(BUILTIN);
        }
    }

    public <T extends CommandOutput<?, ?, ?>> void register(Class<T> commandOutputClass, CommandOutputFactory commandOutputFactory) {
        LettuceAssert.notNull(commandOutputClass, "CommandOutput class must not be null");
        LettuceAssert.notNull(commandOutputFactory, "CommandOutputFactory must not be null");
        OutputRegistry.register(this.registry, commandOutputClass, commandOutputFactory);
    }

    Map<OutputType, CommandOutputFactory> getRegistry() {
        return this.registry;
    }

    private static <T extends CommandOutput> void register(Map<OutputType, CommandOutputFactory> registry, Class<T> commandOutputClass, CommandOutputFactory commandOutputFactory) {
        List<OutputType> outputTypes = OutputRegistry.getOutputTypes(commandOutputClass);
        for (OutputType outputType : outputTypes) {
            registry.put(outputType, commandOutputFactory);
        }
    }

    private static List<OutputType> getOutputTypes(Class<? extends CommandOutput> commandOutputClass) {
        OutputType streamingType = OutputRegistry.getStreamingType(commandOutputClass);
        OutputType componentOutputType = OutputRegistry.getOutputComponentType(commandOutputClass);
        ArrayList<OutputType> types = new ArrayList<OutputType>(2);
        if (streamingType != null) {
            types.add(streamingType);
        }
        if (componentOutputType != null) {
            types.add(componentOutputType);
        }
        return types;
    }

    static OutputType getStreamingType(Class<? extends CommandOutput> commandOutputClass) {
        ClassTypeInformation<? extends CommandOutput> classTypeInformation = ClassTypeInformation.from(commandOutputClass);
        TypeInformation superTypeInformation = classTypeInformation.getSuperTypeInformation((Class)StreamingOutput.class);
        if (superTypeInformation == null) {
            return null;
        }
        List<TypeInformation<?>> typeArguments = superTypeInformation.getTypeArguments();
        Class<?> primaryType = OutputRegistry.getPrimaryType(typeArguments.get(0));
        return new OutputType(primaryType, commandOutputClass, typeArguments.get(0), true);
    }

    static OutputType getOutputComponentType(Class<? extends CommandOutput> commandOutputClass) {
        ClassTypeInformation<? extends CommandOutput> classTypeInformation = ClassTypeInformation.from(commandOutputClass);
        TypeInformation superTypeInformation = classTypeInformation.getSuperTypeInformation((Class)CommandOutput.class);
        if (superTypeInformation == null) {
            return null;
        }
        List<TypeInformation<?>> typeArguments = superTypeInformation.getTypeArguments();
        Class<?> primaryType = OutputRegistry.getPrimaryType(typeArguments.get(2));
        return new OutputType(primaryType, commandOutputClass, typeArguments.get(2), false);
    }

    private static Class<?> getPrimaryType(TypeInformation<?> typeInformation) {
        Class<Object> primaryType = typeInformation.getType();
        while (typeInformation.isCollectionLike() && typeInformation != typeInformation.getComponentType()) {
            typeInformation = typeInformation.getComponentType();
        }
        if (typeInformation instanceof TypeVariableTypeInformation) {
            if (typeInformation.toString().equals("K")) {
                primaryType = KeySurrogate.class;
            }
            if (typeInformation.toString().equals("V")) {
                primaryType = ValueSurrogate.class;
            }
        }
        return primaryType;
    }

    static {
        LinkedHashMap<OutputType, CommandOutputFactory> registry = new LinkedHashMap<OutputType, CommandOutputFactory>();
        OutputRegistry.register(registry, ListOfMapsOutput.class, ListOfMapsOutput::new);
        OutputRegistry.register(registry, ArrayOutput.class, ArrayOutput::new);
        OutputRegistry.register(registry, DoubleOutput.class, DoubleOutput::new);
        OutputRegistry.register(registry, ByteArrayOutput.class, ByteArrayOutput::new);
        OutputRegistry.register(registry, IntegerOutput.class, IntegerOutput::new);
        OutputRegistry.register(registry, KeyOutput.class, KeyOutput::new);
        OutputRegistry.register(registry, ValueOutput.class, ValueOutput::new);
        OutputRegistry.register(registry, KeyListOutput.class, KeyListOutput::new);
        OutputRegistry.register(registry, ValueListOutput.class, ValueListOutput::new);
        OutputRegistry.register(registry, MapOutput.class, MapOutput::new);
        OutputRegistry.register(registry, ValueSetOutput.class, ValueSetOutput::new);
        OutputRegistry.register(registry, BooleanOutput.class, BooleanOutput::new);
        OutputRegistry.register(registry, BooleanListOutput.class, BooleanListOutput::new);
        OutputRegistry.register(registry, GeoCoordinatesListOutput.class, GeoCoordinatesListOutput::new);
        OutputRegistry.register(registry, GeoCoordinatesValueListOutput.class, GeoCoordinatesValueListOutput::new);
        OutputRegistry.register(registry, ScoredValueListOutput.class, ScoredValueListOutput::new);
        OutputRegistry.register(registry, StringValueListOutput.class, StringValueListOutput::new);
        OutputRegistry.register(registry, ValueValueListOutput.class, ValueValueListOutput::new);
        OutputRegistry.register(registry, StringListOutput.class, StringListOutput::new);
        OutputRegistry.register(registry, VoidOutput.class, VoidOutput::new);
        BUILTIN.putAll(registry);
    }

    static class ValueSurrogate {
        ValueSurrogate() {
        }
    }

    static class KeySurrogate {
        KeySurrogate() {
        }
    }
}

