/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic.output;

import com.lambdaworks.redis.dynamic.output.OutputRegistry;
import com.lambdaworks.redis.dynamic.output.OutputSelector;
import com.lambdaworks.redis.dynamic.output.OutputType;
import com.lambdaworks.redis.dynamic.support.TypeInformation;
import com.lambdaworks.redis.dynamic.support.TypeVariableTypeInformation;
import com.lambdaworks.redis.internal.LettuceClassUtils;

public abstract class CommandOutputResolverSupport {
    protected boolean isAssignableFrom(OutputSelector selector, OutputType provider) {
        TypeInformation<?> outputTypeInformation = provider.getTypeInformation();
        TypeInformation<?> selectorTypeInformation = selector.getTypeInformation();
        do {
            if (outputTypeInformation instanceof TypeVariableTypeInformation && selector.containsTypeVariable(outputTypeInformation.toString())) {
                outputTypeInformation = selector.getTypeVariable(outputTypeInformation.toString());
            }
            if (outputTypeInformation.getType() == Object.class && selectorTypeInformation.getComponentType() != null) {
                if (provider.getPrimaryType() == OutputRegistry.KeySurrogate.class) {
                    return selector.isKey();
                }
                if (provider.getPrimaryType() == OutputRegistry.ValueSurrogate.class) {
                    return selector.isValue();
                }
            }
            if (!this.isAssignableFrom(selectorTypeInformation, outputTypeInformation)) {
                return false;
            }
            outputTypeInformation = outputTypeInformation.getComponentType();
            selectorTypeInformation = selectorTypeInformation.getComponentType();
        } while (outputTypeInformation != null && outputTypeInformation.getComponentType() != outputTypeInformation && selectorTypeInformation != null && selectorTypeInformation.getComponentType() != selectorTypeInformation);
        return true;
    }

    protected boolean isAssignableFrom(TypeInformation<?> selector, TypeInformation<?> provider) {
        return selector.isAssignableFrom(provider) || LettuceClassUtils.isAssignable(selector.getType(), provider.getType());
    }
}

