/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic.output;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.dynamic.output.CommandOutputFactory;
import com.lambdaworks.redis.dynamic.output.CommandOutputFactoryResolver;
import com.lambdaworks.redis.dynamic.output.OutputSelector;
import com.lambdaworks.redis.dynamic.support.ClassTypeInformation;
import com.lambdaworks.redis.dynamic.support.TypeInformation;
import com.lambdaworks.redis.internal.LettuceAssert;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodecAwareOutputFactoryResolver
implements CommandOutputFactoryResolver {
    private final CommandOutputFactoryResolver delegate;
    private final TypeInformation<?> keyType;
    private final TypeInformation<?> valueType;
    private final Map<String, TypeInformation<?>> typeVariables = new HashMap();

    public CodecAwareOutputFactoryResolver(CommandOutputFactoryResolver delegate, RedisCodec<?, ?> redisCodec) {
        LettuceAssert.notNull(delegate, "CommandOutputFactoryResolver delegate must not be null");
        LettuceAssert.notNull(redisCodec, "RedisCodec must not be null");
        this.delegate = delegate;
        ClassTypeInformation<?> typeInformation = ClassTypeInformation.from(redisCodec.getClass());
        TypeInformation superTypeInformation = typeInformation.getSuperTypeInformation((Class)RedisCodec.class);
        List<TypeInformation<?>> typeArguments = superTypeInformation.getTypeArguments();
        this.keyType = typeArguments.get(0);
        this.valueType = typeArguments.get(1);
        this.typeVariables.put("K", this.keyType);
        this.typeVariables.put("V", this.valueType);
    }

    @Override
    public CommandOutputFactory resolveCommandOutput(OutputSelector outputSelector) {
        HashMap typeVariables = new HashMap(outputSelector.getTypeVariables());
        typeVariables.putAll(this.typeVariables);
        return this.delegate.resolveCommandOutput(new OutputSelector(outputSelector.getTypeInformation(), this.isKeyType(outputSelector.getTypeInformation()), this.isValueType(outputSelector.getTypeInformation()), typeVariables));
    }

    @Override
    public CommandOutputFactory resolveStreamingCommandOutput(OutputSelector outputSelector) {
        HashMap typeVariables = new HashMap(outputSelector.getTypeVariables());
        typeVariables.putAll(this.typeVariables);
        return this.delegate.resolveStreamingCommandOutput(new OutputSelector(outputSelector.getTypeInformation(), this.isKeyType(outputSelector.getTypeInformation()), this.isValueType(outputSelector.getTypeInformation()), typeVariables));
    }

    protected boolean isKeyType(TypeInformation<?> typeInformation) {
        return this.walkComponentTypeAssignability(typeInformation, this.keyType);
    }

    protected boolean isValueType(TypeInformation<?> typeInformation) {
        return this.walkComponentTypeAssignability(typeInformation, this.valueType);
    }

    private boolean walkComponentTypeAssignability(TypeInformation<?> typeInformation, TypeInformation<?> sourceType) {
        do {
            if (!typeInformation.isAssignableFrom(sourceType)) continue;
            return true;
        } while ((typeInformation = typeInformation.getComponentType()) != null);
        return false;
    }
}

