/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic.intercept;

import com.lambdaworks.redis.dynamic.intercept.DefaultMethodInvocation;
import com.lambdaworks.redis.dynamic.intercept.MethodInterceptor;
import com.lambdaworks.redis.internal.AbstractInvocationHandler;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.internal.LettuceLists;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InvocationProxyFactory {
    private final List<MethodInterceptor> interceptors = new ArrayList<MethodInterceptor>();
    private final List<Class<?>> interfaces = new ArrayList();

    public <T> T createProxy(ClassLoader classLoader) {
        LettuceAssert.notNull(classLoader, "ClassLoader must not be null");
        Class[] interfaces = this.interfaces.toArray(new Class[this.interfaces.size()]);
        return (T)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new InterceptorChainInvocationHandler(this.interceptors));
    }

    public void addInterface(Class<?> ifc) {
        LettuceAssert.notNull(ifc, "Interface type must not be null");
        LettuceAssert.isTrue(ifc.isInterface(), "Type must be an interface");
        this.interfaces.add(ifc);
    }

    public void addInterceptor(MethodInterceptor interceptor) {
        LettuceAssert.notNull(interceptor, "MethodInterceptor must not be null");
        this.interceptors.add(interceptor);
    }

    private static class InterceptorChainInvocationHandler
    extends AbstractInvocationHandler {
        private final List<MethodInterceptor> interceptors;

        InterceptorChainInvocationHandler(List<MethodInterceptor> interceptors) {
            this.interceptors = LettuceLists.newList(interceptors);
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            Iterator<MethodInterceptor> iterator = this.interceptors.iterator();
            if (iterator.hasNext()) {
                return iterator.next().invoke(this.getInvocation(method, args, iterator));
            }
            return null;
        }

        private DefaultMethodInvocation getInvocation(final Method method, final Object[] args, final Iterator<MethodInterceptor> iterator) {
            return new DefaultMethodInvocation(method, args){

                @Override
                public Object proceed() throws Throwable {
                    if (iterator.hasNext()) {
                        return ((MethodInterceptor)iterator.next()).invoke(this.getInvocation(method, args, iterator));
                    }
                    return null;
                }
            };
        }
    }
}

