/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic;

import com.lambdaworks.redis.AbstractRedisReactiveCommands;
import com.lambdaworks.redis.LettuceFutures;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.api.async.BaseRedisAsyncCommands;
import com.lambdaworks.redis.api.reactive.BaseRedisReactiveCommands;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.codec.ByteArrayCodec;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.StringCodec;
import com.lambdaworks.redis.dynamic.CommandCreationException;
import com.lambdaworks.redis.dynamic.CommandFactory;
import com.lambdaworks.redis.dynamic.CommandMethod;
import com.lambdaworks.redis.dynamic.CommandMethodVerifier;
import com.lambdaworks.redis.dynamic.CommandSegmentCommandFactory;
import com.lambdaworks.redis.dynamic.Commands;
import com.lambdaworks.redis.dynamic.DefaultRedisCommandsMetadata;
import com.lambdaworks.redis.dynamic.ReactiveCommandSegmentCommandFactory;
import com.lambdaworks.redis.dynamic.ReactiveWrappers;
import com.lambdaworks.redis.dynamic.RedisCommandsMetadata;
import com.lambdaworks.redis.dynamic.codec.AnnotationRedisCodecResolver;
import com.lambdaworks.redis.dynamic.domain.Timeout;
import com.lambdaworks.redis.dynamic.intercept.InvocationProxyFactory;
import com.lambdaworks.redis.dynamic.intercept.MethodInterceptor;
import com.lambdaworks.redis.dynamic.intercept.MethodInvocation;
import com.lambdaworks.redis.dynamic.output.CodecAwareOutputFactoryResolver;
import com.lambdaworks.redis.dynamic.output.CommandOutputFactoryResolver;
import com.lambdaworks.redis.dynamic.output.OutputRegistry;
import com.lambdaworks.redis.dynamic.output.OutputRegistryCommandOutputFactoryResolver;
import com.lambdaworks.redis.dynamic.parameter.ExecutionSpecificParameters;
import com.lambdaworks.redis.dynamic.segment.AnnotationCommandSegmentFactory;
import com.lambdaworks.redis.dynamic.segment.CommandSegments;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.internal.LettuceLists;
import com.lambdaworks.redis.models.command.CommandDetail;
import com.lambdaworks.redis.models.command.CommandDetailParser;
import com.lambdaworks.redis.protocol.LettuceCharsets;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class RedisCommandFactory {
    private final StatefulConnection<?, ?> connection;
    private final CommandMethodVerifier commandMethodVerifier;
    private final List<RedisCodec<?, ?>> redisCodecs = new ArrayList();
    private CommandOutputFactoryResolver commandOutputFactoryResolver = new OutputRegistryCommandOutputFactoryResolver(new OutputRegistry());
    private boolean verifyCommandMethods = true;

    public RedisCommandFactory(StatefulConnection<?, ?> connection) {
        this(connection, LettuceLists.newList(new ByteArrayCodec(), new StringCodec(LettuceCharsets.UTF8)));
    }

    public RedisCommandFactory(StatefulConnection<?, ?> connection, Iterable<RedisCodec<?, ?>> redisCodecs) {
        LettuceAssert.notNull(connection, "Redis Connection must not be null");
        LettuceAssert.notNull(redisCodecs, "Iterable of RedisCodec must not be null");
        this.connection = connection;
        this.redisCodecs.addAll(LettuceLists.newList(redisCodecs));
        this.commandMethodVerifier = new CommandMethodVerifier(this.getCommands(connection));
    }

    private List<CommandDetail> getCommands(StatefulConnection<?, ?> connection) {
        List<Object> commands = Collections.emptyList();
        if (connection instanceof StatefulRedisConnection) {
            commands = ((StatefulRedisConnection)connection).sync().command();
        }
        if (connection instanceof StatefulRedisClusterConnection) {
            commands = ((StatefulRedisClusterConnection)connection).sync().command();
        }
        if (commands.isEmpty()) {
            this.verifyCommandMethods = false;
        }
        return CommandDetailParser.parse(commands);
    }

    public void setCommandOutputFactoryResolver(CommandOutputFactoryResolver commandOutputFactoryResolver) {
        LettuceAssert.notNull(commandOutputFactoryResolver, "CommandOutputFactoryResolver must not be null");
        this.commandOutputFactoryResolver = commandOutputFactoryResolver;
    }

    public void setVerifyCommandMethods(boolean verifyCommandMethods) {
        this.verifyCommandMethods = verifyCommandMethods;
    }

    public <T extends Commands> T getCommands(Class<T> commandInterface) {
        LettuceAssert.notNull(commandInterface, "Redis Command Interface must not be null");
        DefaultRedisCommandsMetadata redisCommandsMetadata = new DefaultRedisCommandsMetadata(commandInterface);
        InvocationProxyFactory factory = new InvocationProxyFactory();
        factory.addInterface(commandInterface);
        if (this.connection instanceof StatefulRedisConnection) {
            StatefulRedisConnection redisConnection = (StatefulRedisConnection)this.connection;
            factory.addInterceptor(new ReactiveCommandFactoryExecutorMethodInterceptor(redisCommandsMetadata, redisConnection.reactive()));
            factory.addInterceptor(new CommandFactoryExecutorMethodInterceptor(redisCommandsMetadata, redisConnection.async()));
        }
        return (T)((Commands)factory.createProxy(commandInterface.getClassLoader()));
    }

    static interface RedisCommandFactoryResolver {
        public CommandFactory resolveRedisCommandFactory(Method var1, RedisCommandsMetadata var2);
    }

    class ReactiveRedisCommandFactoryResolver
    implements RedisCommandFactoryResolver {
        final AnnotationCommandSegmentFactory commandSegmentFactory = new AnnotationCommandSegmentFactory();
        final AnnotationRedisCodecResolver codecResolver;

        ReactiveRedisCommandFactoryResolver(List<RedisCodec<?, ?>> redisCodecs) {
            this.codecResolver = new AnnotationRedisCodecResolver(redisCodecs);
        }

        @Override
        public ReactiveCommandSegmentCommandFactory resolveRedisCommandFactory(Method method, RedisCommandsMetadata redisCommandsMetadata) {
            CommandMethod commandMethod = new CommandMethod(method);
            RedisCodec<?, ?> codec = this.codecResolver.resolve(commandMethod);
            if (codec == null) {
                throw new CommandCreationException(commandMethod, "Cannot resolve codec.");
            }
            CommandSegments commandSegments = this.commandSegmentFactory.createCommandSegments(commandMethod);
            if (RedisCommandFactory.this.verifyCommandMethods) {
                RedisCommandFactory.this.commandMethodVerifier.validate(commandSegments, commandMethod);
            }
            CodecAwareOutputFactoryResolver outputFactoryResolver = new CodecAwareOutputFactoryResolver(RedisCommandFactory.this.commandOutputFactoryResolver, codec);
            return new ReactiveCommandSegmentCommandFactory(commandSegments, commandMethod, codec, outputFactoryResolver);
        }
    }

    class DefaultRedisCommandFactoryResolver
    implements RedisCommandFactoryResolver {
        final AnnotationCommandSegmentFactory commandSegmentFactory = new AnnotationCommandSegmentFactory();
        final AnnotationRedisCodecResolver codecResolver;

        DefaultRedisCommandFactoryResolver(List<RedisCodec<?, ?>> redisCodecs) {
            this.codecResolver = new AnnotationRedisCodecResolver(redisCodecs);
        }

        @Override
        public CommandFactory resolveRedisCommandFactory(Method method, RedisCommandsMetadata redisCommandsMetadata) {
            CommandMethod commandMethod = new CommandMethod(method);
            RedisCodec<?, ?> codec = this.codecResolver.resolve(commandMethod);
            if (codec == null) {
                throw new CommandCreationException(commandMethod, "Cannot resolve codec.");
            }
            CodecAwareOutputFactoryResolver outputFactoryResolver = new CodecAwareOutputFactoryResolver(RedisCommandFactory.this.commandOutputFactoryResolver, codec);
            CommandSegments commandSegments = this.commandSegmentFactory.createCommandSegments(commandMethod);
            if (RedisCommandFactory.this.verifyCommandMethods) {
                RedisCommandFactory.this.commandMethodVerifier.validate(commandSegments, commandMethod);
            }
            if (commandMethod.isReactiveExecution()) {
                return new ReactiveCommandSegmentCommandFactory(commandSegments, commandMethod, codec, outputFactoryResolver);
            }
            return new CommandSegmentCommandFactory(commandSegments, commandMethod, codec, outputFactoryResolver);
        }
    }

    class ReactiveCommandFactoryExecutorMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, ReactiveCommandSegmentCommandFactory> commandFactories = new ConcurrentHashMap<Method, ReactiveCommandSegmentCommandFactory>();
        private final AbstractRedisReactiveCommands<?, ?> redisReactiveCommands;

        public ReactiveCommandFactoryExecutorMethodInterceptor(RedisCommandsMetadata redisCommandsMetadata, BaseRedisReactiveCommands<?, ?> redisReactiveCommands) {
            ReactiveRedisCommandFactoryResolver lookupStrategy = new ReactiveRedisCommandFactoryResolver(RedisCommandFactory.this.redisCodecs);
            for (Method method : redisCommandsMetadata.getMethods()) {
                if (!ReactiveWrappers.supports(method.getReturnType())) continue;
                ReactiveCommandSegmentCommandFactory commandFactory = lookupStrategy.resolveRedisCommandFactory(method, redisCommandsMetadata);
                this.commandFactories.put(method, commandFactory);
            }
            this.redisReactiveCommands = (AbstractRedisReactiveCommands)redisReactiveCommands;
        }

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object[] arguments = invocation.getArguments();
            if (this.hasFactoryFor(method)) {
                ReactiveCommandSegmentCommandFactory commandFactory = this.commandFactories.get(method);
                if (ReactiveWrappers.isSingle(method.getReturnType())) {
                    return this.redisReactiveCommands.createMono(() -> commandFactory.createCommand(arguments));
                }
                if (commandFactory.isStreamingExecution()) {
                    return this.redisReactiveCommands.createDissolvingFlux(() -> commandFactory.createCommand(arguments));
                }
                return this.redisReactiveCommands.createFlux(() -> commandFactory.createCommand(arguments));
            }
            return invocation.proceed();
        }

        private boolean hasFactoryFor(Method method) {
            return this.commandFactories.containsKey(method);
        }
    }

    class CommandFactoryExecutorMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, CommandFactory> commandFactories = new ConcurrentHashMap<Method, CommandFactory>();
        private final BaseRedisAsyncCommands<?, ?> redisAsyncCommands;

        public CommandFactoryExecutorMethodInterceptor(RedisCommandsMetadata redisCommandsMetadata, BaseRedisAsyncCommands<?, ?> redisAsyncCommands) {
            DefaultRedisCommandFactoryResolver lookupStrategy = new DefaultRedisCommandFactoryResolver(RedisCommandFactory.this.redisCodecs);
            for (Method method : redisCommandsMetadata.getMethods()) {
                if (ReactiveWrappers.supports(method.getReturnType())) continue;
                CommandFactory commandFactory = lookupStrategy.resolveRedisCommandFactory(method, redisCommandsMetadata);
                this.commandFactories.put(method, commandFactory);
            }
            this.redisAsyncCommands = redisAsyncCommands;
        }

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object[] arguments = invocation.getArguments();
            if (this.hasFactoryFor(method)) {
                Timeout timeoutArg;
                ExecutionSpecificParameters executionSpecificParameters;
                CommandMethod commandMethod = new CommandMethod(method);
                CommandFactory commandFactory = this.commandFactories.get(method);
                RedisCommand<?, ?, ?> command = commandFactory.createCommand(arguments);
                if (commandMethod.isFutureExecution()) {
                    return this.redisAsyncCommands.dispatch(command.getType(), command.getOutput(), command.getArgs());
                }
                RedisFuture<?> dispatch = this.redisAsyncCommands.dispatch(command.getType(), command.getOutput(), command.getArgs());
                long timeout = RedisCommandFactory.this.connection.getTimeout();
                TimeUnit unit = RedisCommandFactory.this.connection.getTimeoutUnit();
                if (commandMethod.getParameters() instanceof ExecutionSpecificParameters && (executionSpecificParameters = (ExecutionSpecificParameters)commandMethod.getParameters()).hasTimeoutIndex() && (timeoutArg = (Timeout)arguments[executionSpecificParameters.getTimeoutIndex()]) != null) {
                    timeout = timeoutArg.getTimeout();
                    unit = timeoutArg.getTimeUnit();
                }
                LettuceFutures.awaitAll(timeout, unit, dispatch);
                return dispatch.get();
            }
            return invocation.proceed();
        }

        private boolean hasFactoryFor(Method method) {
            return this.commandFactories.containsKey(method);
        }
    }
}

