/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic;

import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.internal.LettuceClassUtils;
import java.util.HashSet;
import java.util.Set;

abstract class ReactiveWrappers {
    private static final Class<?> MONO = LettuceClassUtils.findClass("reactor.core.publisher.Mono");
    private static final Class<?> FLUX = LettuceClassUtils.findClass("reactor.core.publisher.Flux");
    private static final Class<?> PUBLISHER = LettuceClassUtils.findClass("org.reactivestreams.Publisher");
    private static final Set<Class<?>> REACTIVE_WRAPPERS = new HashSet();
    private static final Set<Class<?>> SINGLE_WRAPPERS = new HashSet();
    private static final Set<Class<?>> MULTI_WRAPPERS = new HashSet();

    ReactiveWrappers() {
    }

    public static boolean supports(Class<?> wrapperType) {
        LettuceAssert.notNull(wrapperType, "Wrapper type must not be null");
        return REACTIVE_WRAPPERS.contains(wrapperType);
    }

    public static boolean isSingle(Class<?> wrapperType) {
        LettuceAssert.notNull(wrapperType, "Wrapper type must not be null");
        return SINGLE_WRAPPERS.contains(wrapperType) && !ReactiveWrappers.isMulti(wrapperType);
    }

    public static boolean isMulti(Class<?> wrapperType) {
        LettuceAssert.notNull(wrapperType, "Wrapper type must not be null");
        return MULTI_WRAPPERS.contains(wrapperType);
    }

    static {
        if (MONO != null) {
            REACTIVE_WRAPPERS.add(MONO);
            SINGLE_WRAPPERS.add(MONO);
        }
        if (FLUX != null) {
            REACTIVE_WRAPPERS.add(FLUX);
            MULTI_WRAPPERS.add(FLUX);
        }
        if (PUBLISHER != null) {
            REACTIVE_WRAPPERS.add(PUBLISHER);
            MULTI_WRAPPERS.add(PUBLISHER);
        }
    }
}

