/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.dynamic.CommandCreationException;
import com.lambdaworks.redis.dynamic.CommandMethod;
import com.lambdaworks.redis.dynamic.CommandSegmentCommandFactory;
import com.lambdaworks.redis.dynamic.output.CommandOutputFactory;
import com.lambdaworks.redis.dynamic.output.CommandOutputFactoryResolver;
import com.lambdaworks.redis.dynamic.output.OutputSelector;
import com.lambdaworks.redis.dynamic.parameter.ExecutionSpecificParameters;
import com.lambdaworks.redis.dynamic.segment.CommandSegments;

class ReactiveCommandSegmentCommandFactory<K, V>
extends CommandSegmentCommandFactory<K, V> {
    private boolean streamingExecution;

    public ReactiveCommandSegmentCommandFactory(CommandSegments commandSegments, CommandMethod commandMethod, RedisCodec<K, V> redisCodec, CommandOutputFactoryResolver outputResolver) {
        super(commandSegments, commandMethod, redisCodec, outputResolver);
        ExecutionSpecificParameters executionAwareParameters;
        if (commandMethod.getParameters() instanceof ExecutionSpecificParameters && (executionAwareParameters = (ExecutionSpecificParameters)commandMethod.getParameters()).hasTimeoutIndex()) {
            throw new CommandCreationException(commandMethod, "Reactive command methods do not support Timeout parameters");
        }
    }

    @Override
    protected CommandOutputFactory resolveCommandOutputFactory(OutputSelector outputSelector) {
        CommandOutputFactory factory = this.getOutputResolver().resolveStreamingCommandOutput(outputSelector);
        if (factory != null) {
            this.streamingExecution = true;
            return factory;
        }
        return super.resolveCommandOutputFactory(outputSelector);
    }

    public boolean isStreamingExecution() {
        return this.streamingExecution;
    }
}

