/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic;

import com.lambdaworks.redis.GeoCoordinates;
import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.Limit;
import com.lambdaworks.redis.Range;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.dynamic.annotation.Key;
import com.lambdaworks.redis.dynamic.annotation.Value;
import com.lambdaworks.redis.dynamic.parameter.MethodParametersAccessor;
import com.lambdaworks.redis.dynamic.parameter.Parameter;
import com.lambdaworks.redis.dynamic.parameter.Parameters;
import com.lambdaworks.redis.internal.LettuceAssert;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

class DefaultMethodParametersAccessor
implements MethodParametersAccessor {
    private final Parameters parameters;
    private final List<Object> values;

    public DefaultMethodParametersAccessor(Parameters parameters, Object ... values) {
        LettuceAssert.notNull(parameters, "Parameters must not be null");
        LettuceAssert.notNull(values, "Values must not be null");
        this.parameters = parameters;
        this.values = Arrays.asList(values);
    }

    @Override
    public int getParameterCount() {
        return this.parameters.getBindableParameters().size();
    }

    @Override
    public Object getBindableValue(int index) {
        return this.values.get(this.parameters.getBindableParameter(index).getParameterIndex());
    }

    @Override
    public boolean isKey(int index) {
        return this.parameters.getBindableParameter(index).findAnnotation(Key.class) != null;
    }

    @Override
    public boolean isValue(int index) {
        return this.parameters.getBindableParameter(index).findAnnotation(Value.class) != null;
    }

    @Override
    public Iterator<Object> iterator() {
        return new BindableParameterIterator(this);
    }

    @Override
    public int resolveParameterIndex(String name) {
        List bindableParameters = this.parameters.getBindableParameters();
        for (int i = 0; i < bindableParameters.size(); ++i) {
            if (!name.equals(((Parameter)bindableParameters.get(i)).getName())) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Cannot resolve named parameter %s", name));
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isBindableNullValue(int index) {
        Parameter bindableParameter = this.parameters.getBindableParameter(index);
        return !bindableParameter.isAssignableTo(Limit.class) && !bindableParameter.isAssignableTo(com.lambdaworks.redis.Value.class) && !bindableParameter.isAssignableTo(KeyValue.class) && !bindableParameter.isAssignableTo(ScoredValue.class) && !bindableParameter.isAssignableTo(GeoCoordinates.class) && !bindableParameter.isAssignableTo(Range.class);
    }

    private static class BindableParameterIterator
    implements Iterator<Object> {
        private final int bindableParameterCount;
        private final DefaultMethodParametersAccessor accessor;
        private int currentIndex = 0;

        public BindableParameterIterator(DefaultMethodParametersAccessor accessor) {
            LettuceAssert.notNull(accessor, "ParametersParameterAccessor must not be null!");
            this.accessor = accessor;
            this.bindableParameterCount = accessor.getParameters().getBindableParameters().size();
        }

        @Override
        public Object next() {
            return this.accessor.getBindableValue(this.currentIndex++);
        }

        @Override
        public boolean hasNext() {
            return this.bindableParameterCount > this.currentIndex;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

