/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.dynamic.CodecAwareMethodParametersAccessor;
import com.lambdaworks.redis.dynamic.CommandCreationException;
import com.lambdaworks.redis.dynamic.CommandFactory;
import com.lambdaworks.redis.dynamic.CommandMethod;
import com.lambdaworks.redis.dynamic.DefaultMethodParametersAccessor;
import com.lambdaworks.redis.dynamic.ParameterBinder;
import com.lambdaworks.redis.dynamic.output.CommandOutputFactory;
import com.lambdaworks.redis.dynamic.output.CommandOutputFactoryResolver;
import com.lambdaworks.redis.dynamic.output.OutputSelector;
import com.lambdaworks.redis.dynamic.parameter.ExecutionSpecificParameters;
import com.lambdaworks.redis.dynamic.segment.CommandSegments;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.RedisCommand;

class CommandSegmentCommandFactory<K, V>
implements CommandFactory {
    private final CommandMethod commandMethod;
    private final CommandSegments segments;
    private final CommandOutputFactoryResolver outputResolver;
    private final RedisCodec<K, V> redisCodec;
    private final ParameterBinder parameterBinder = new ParameterBinder();
    private final CommandOutputFactory outputFactory;

    public CommandSegmentCommandFactory(CommandSegments commandSegments, CommandMethod commandMethod, RedisCodec<K, V> redisCodec, CommandOutputFactoryResolver outputResolver) {
        this.segments = commandSegments;
        this.commandMethod = commandMethod;
        this.redisCodec = redisCodec;
        this.outputResolver = outputResolver;
        OutputSelector outputSelector = new OutputSelector(commandMethod.getActualReturnType());
        CommandOutputFactory factory = this.resolveCommandOutputFactory(outputSelector);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Cannot resolve CommandOutput for result type %s on method %s", commandMethod.getActualReturnType(), commandMethod.getMethod()));
        }
        if (commandMethod.getParameters() instanceof ExecutionSpecificParameters) {
            ExecutionSpecificParameters executionAwareParameters = (ExecutionSpecificParameters)commandMethod.getParameters();
            if (commandMethod.isFutureExecution() && executionAwareParameters.hasTimeoutIndex()) {
                throw new CommandCreationException(commandMethod, "Asynchronous command methods do not support Timeout parameters");
            }
        }
        this.outputFactory = factory;
    }

    protected CommandOutputFactoryResolver getOutputResolver() {
        return this.outputResolver;
    }

    protected CommandOutputFactory resolveCommandOutputFactory(OutputSelector outputSelector) {
        return this.outputResolver.resolveCommandOutput(outputSelector);
    }

    @Override
    public RedisCommand<?, ?, ?> createCommand(Object[] parameters) {
        CodecAwareMethodParametersAccessor parametersAccessor = new CodecAwareMethodParametersAccessor(new DefaultMethodParametersAccessor(this.commandMethod.getParameters(), parameters), this.redisCodec);
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.redisCodec);
        CommandOutput<K, V, ?> output = this.outputFactory.create(this.redisCodec);
        Command command = new Command(this.segments.getCommandType(), output, args);
        this.parameterBinder.bind(args, this.segments, parametersAccessor);
        return command;
    }
}

