/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic;

import com.lambdaworks.redis.GeoCoordinates;
import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.Limit;
import com.lambdaworks.redis.Range;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.dynamic.CommandMethod;
import com.lambdaworks.redis.dynamic.CommandMethodSyntaxException;
import com.lambdaworks.redis.dynamic.parameter.Parameter;
import com.lambdaworks.redis.dynamic.segment.CommandSegments;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.internal.LettuceLists;
import com.lambdaworks.redis.models.command.CommandDetail;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class CommandMethodVerifier {
    public static final int DEFAULT_MAX_DISTANCE = 2;
    private List<CommandDetail> commandDetails;

    public CommandMethodVerifier(List<CommandDetail> commandDetails) {
        LettuceAssert.notNull(commandDetails, "Command details must not be null");
        this.commandDetails = LettuceLists.newList(commandDetails);
    }

    public void validate(CommandSegments commandSegments, CommandMethod commandMethod) throws CommandMethodSyntaxException {
        LettuceAssert.notEmpty(commandSegments.getCommandType().name(), "Command name must not be empty");
        CommandDetail commandDetail = this.findCommandDetail(commandSegments.getCommandType().name()).orElseThrow(() -> this.syntaxException(commandSegments.getCommandType().name(), commandMethod));
        this.validateParameters(commandDetail, commandSegments, commandMethod);
    }

    private void validateParameters(CommandDetail commandDetail, CommandSegments commandSegments, CommandMethod commandMethod) {
        List<? extends Parameter> bindableParameters = commandMethod.getParameters().getBindableParameters();
        int availableParameterCount = this.calculateAvailableParameterCount(commandSegments, bindableParameters);
        if (commandDetail.getArity() - 1 == availableParameterCount) {
            return;
        }
        if (0 > commandDetail.getArity() && availableParameterCount >= -(commandDetail.getArity() + 1)) {
            return;
        }
        for (Parameter parameter : bindableParameters) {
            if (!parameter.getTypeInformation().isCollectionLike()) continue;
            return;
        }
        String message = commandDetail.getArity() == 1 ? String.format("Command %s accepts no parameters.", commandDetail.getName().toUpperCase()) : (commandDetail.getArity() < -1 ? String.format("Command %s requires at least %d parameters but method declares %d parameter(s).", commandDetail.getName().toUpperCase(), Math.abs(commandDetail.getArity()) - 1, availableParameterCount) : String.format("Command %s accepts %d parameters but method declares %d parameter(s).", commandDetail.getName().toUpperCase(), commandDetail.getArity() - 1, availableParameterCount));
        throw new CommandMethodSyntaxException(commandMethod, message);
    }

    private int calculateAvailableParameterCount(CommandSegments commandSegments, List<? extends Parameter> bindableParameters) {
        int count = commandSegments.size();
        for (Parameter parameter : bindableParameters) {
            if (parameter.isAssignableTo(KeyValue.class) || parameter.isAssignableTo(ScoredValue.class)) {
                ++count;
            }
            if (parameter.isAssignableTo(GeoCoordinates.class) || parameter.isAssignableTo(Range.class)) {
                ++count;
            }
            if (parameter.isAssignableTo(Limit.class)) {
                count += 2;
            }
            ++count;
        }
        return count;
    }

    private CommandMethodSyntaxException syntaxException(String commandName, CommandMethod commandMethod) {
        CommandMatches commandMatches = CommandMatches.forCommand(commandName, this.commandDetails);
        if (commandMatches.hasMatches()) {
            return new CommandMethodSyntaxException(commandMethod, String.format("Command %s does not exist. Did you mean: %s?", commandName, commandMatches));
        }
        return new CommandMethodSyntaxException(commandMethod, String.format("Command %s does not exist", commandName));
    }

    private Optional<CommandDetail> findCommandDetail(String commandName) {
        return this.commandDetails.stream().filter(commandDetail -> commandDetail.getName().equalsIgnoreCase(commandName)).findFirst();
    }

    static class CommandMatches {
        private final List<String> matches = new ArrayList<String>();

        private CommandMatches(List<String> matches) {
            this.matches.addAll(matches);
        }

        public static CommandMatches forCommand(String command, List<CommandDetail> commandDetails) {
            return new CommandMatches(CommandMatches.calculateMatches(command, commandDetails));
        }

        private static List<String> calculateMatches(String command, List<CommandDetail> commandDetails) {
            return commandDetails.stream().filter(commandDetail -> CommandMatches.calculateStringDistance(commandDetail.getName().toLowerCase(), command.toLowerCase()) <= 2).map(CommandDetail::getName).map(String::toUpperCase).sorted(CommandMatches::calculateStringDistance).collect(Collectors.toList());
        }

        public boolean hasMatches() {
            return !this.matches.isEmpty();
        }

        public String toString() {
            return LettuceStrings.collectionToDelimitedString(this.matches, ", ", "", "");
        }

        private static int calculateStringDistance(String s1, String s2) {
            int i;
            if (s1.length() == 0) {
                return s2.length();
            }
            if (s2.length() == 0) {
                return s1.length();
            }
            int[][] d = new int[s1.length() + 1][s2.length() + 1];
            for (i = 0; i <= s1.length(); ++i) {
                d[i][0] = i;
            }
            for (int j = 0; j <= s2.length(); ++j) {
                d[0][j] = j;
            }
            for (i = 1; i <= s1.length(); ++i) {
                char s_i = s1.charAt(i - 1);
                for (int j = 1; j <= s2.length(); ++j) {
                    char t_j = s2.charAt(j - 1);
                    int cost = s_i == t_j ? 0 : 1;
                    d[i][j] = Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + cost);
                }
            }
            return d[s1.length()][s2.length()];
        }
    }
}

