/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic;

import com.lambdaworks.redis.dynamic.ReactiveWrappers;
import com.lambdaworks.redis.dynamic.parameter.ExecutionSpecificParameters;
import com.lambdaworks.redis.dynamic.parameter.Parameter;
import com.lambdaworks.redis.dynamic.parameter.Parameters;
import com.lambdaworks.redis.dynamic.support.ClassTypeInformation;
import com.lambdaworks.redis.dynamic.support.TypeInformation;
import com.lambdaworks.redis.internal.LettuceAssert;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.reactivestreams.Publisher;

public class CommandMethod {
    private final Method method;
    private final TypeInformation<?> returnType;
    private final List<Class<?>> arguments = new ArrayList();
    private final Parameters<? extends Parameter> parameters;
    private final TypeInformation<?> actualReturnType;

    public CommandMethod(Method method) {
        this(method, new ExecutionSpecificParameters(method));
    }

    public CommandMethod(Method method, Parameters<?> parameters) {
        LettuceAssert.notNull(method, "Method must not be null");
        LettuceAssert.notNull(parameters, "Parameters must not be null");
        this.method = method;
        this.returnType = ClassTypeInformation.fromReturnTypeOf(method);
        this.parameters = parameters;
        Collections.addAll(this.arguments, method.getParameterTypes());
        TypeInformation<?> actualReturnType = this.returnType;
        while (Future.class.isAssignableFrom(actualReturnType.getType()) || Publisher.class.isAssignableFrom(actualReturnType.getType())) {
            actualReturnType = actualReturnType.getComponentType();
        }
        this.actualReturnType = actualReturnType;
    }

    public Parameters<? extends Parameter> getParameters() {
        return this.parameters;
    }

    public Method getMethod() {
        return this.method;
    }

    public TypeInformation<?> getReturnType() {
        return this.returnType;
    }

    public TypeInformation<?> getActualReturnType() {
        return this.actualReturnType;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.method.getAnnotation(annotationClass);
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
        return this.method.getAnnotation(annotationClass) != null;
    }

    public String getName() {
        return this.method.getName();
    }

    public boolean isFutureExecution() {
        return Future.class.isAssignableFrom(this.getReturnType().getType());
    }

    public boolean isReactiveExecution() {
        return ReactiveWrappers.supports(this.getReturnType().getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandMethod)) {
            return false;
        }
        CommandMethod that = (CommandMethod)o;
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (this.returnType != null ? !this.returnType.equals(that.returnType) : that.returnType != null) {
            return false;
        }
        return this.arguments != null ? this.arguments.equals(that.arguments) : that.arguments == null;
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.method.toGenericString();
    }
}

