/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.dynamic.parameter.MethodParametersAccessor;
import com.lambdaworks.redis.dynamic.support.ClassTypeInformation;
import com.lambdaworks.redis.dynamic.support.TypeInformation;
import com.lambdaworks.redis.internal.LettuceAssert;
import java.util.Iterator;

public class CodecAwareMethodParametersAccessor
implements MethodParametersAccessor {
    private final MethodParametersAccessor delegate;
    private final TypeInformation<?> keyType;
    private final TypeInformation<?> valueType;

    public CodecAwareMethodParametersAccessor(MethodParametersAccessor delegate, RedisCodec<?, ?> redisCodec) {
        LettuceAssert.notNull(delegate, "MethodParametersAccessor must not be null");
        LettuceAssert.notNull(redisCodec, "RedisCodec must not be null");
        this.delegate = delegate;
        ClassTypeInformation<?> typeInformation = ClassTypeInformation.from(redisCodec.getClass());
        this.keyType = typeInformation.getTypeArgument((Class)RedisCodec.class, 0);
        this.valueType = typeInformation.getTypeArgument((Class)RedisCodec.class, 1);
    }

    @Override
    public int getParameterCount() {
        return this.delegate.getParameterCount();
    }

    @Override
    public Object getBindableValue(int index) {
        return this.delegate.getBindableValue(index);
    }

    @Override
    public boolean isKey(int index) {
        if (this.delegate.isValue(index)) {
            return false;
        }
        if (this.delegate.isKey(index)) {
            return true;
        }
        Object bindableValue = this.getBindableValue(index);
        return bindableValue != null && this.keyType.getType().isAssignableFrom(bindableValue.getClass());
    }

    @Override
    public boolean isValue(int index) {
        if (this.delegate.isKey(index)) {
            return false;
        }
        if (this.delegate.isValue(index)) {
            return true;
        }
        Object bindableValue = this.getBindableValue(index);
        return bindableValue != null && this.valueType.getType().isAssignableFrom(bindableValue.getClass());
    }

    @Override
    public Iterator<Object> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int resolveParameterIndex(String name) {
        return this.delegate.resolveParameterIndex(name);
    }

    @Override
    public boolean isBindableNullValue(int index) {
        return this.delegate.isBindableNullValue(index);
    }
}

