/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.codec;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.LettuceCharsets;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class Utf8StringCodec
implements RedisCodec<String, String> {
    private static final byte[] EMPTY = new byte[0];
    private Charset charset = LettuceCharsets.UTF8;
    private CharsetDecoder decoder = this.charset.newDecoder();
    private CharBuffer chars = CharBuffer.allocate(1024);

    @Override
    public String decodeKey(ByteBuffer bytes) {
        return this.decode(bytes);
    }

    @Override
    public String decodeValue(ByteBuffer bytes) {
        return this.decode(bytes);
    }

    @Override
    public ByteBuffer encodeKey(String key) {
        return this.encode(key);
    }

    @Override
    public ByteBuffer encodeValue(String value) {
        return this.encode(value);
    }

    private synchronized String decode(ByteBuffer bytes) {
        this.chars.clear();
        bytes.mark();
        this.decoder.reset();
        while (this.decoder.decode(bytes, this.chars, true) == CoderResult.OVERFLOW || this.decoder.flush(this.chars) == CoderResult.OVERFLOW) {
            this.chars = CharBuffer.allocate(this.chars.capacity() * 2);
            bytes.reset();
        }
        return this.chars.flip().toString();
    }

    private ByteBuffer encode(String string) {
        if (string == null) {
            return ByteBuffer.wrap(EMPTY);
        }
        return this.charset.encode(string);
    }
}

