/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.cluster.PipelinedRedisFuture;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;

class MultiNodeExecution {
    MultiNodeExecution() {
    }

    static <T> T execute(Callable<T> function) {
        try {
            return function.call();
        }
        catch (Exception e) {
            throw new RedisException(e);
        }
    }

    protected static RedisFuture<Long> aggregateAsync(Map<?, RedisFuture<Long>> executions) {
        return new PipelinedRedisFuture<Long>(executions, objectPipelinedRedisFuture -> {
            AtomicLong result = new AtomicLong();
            for (RedisFuture future : executions.values()) {
                Long value = MultiNodeExecution.execute(() -> (Long)future.get());
                if (value == null) continue;
                result.getAndAdd(value);
            }
            return result.get();
        });
    }

    protected static <T> RedisFuture<T> firstOfAsync(Map<?, RedisFuture<T>> executions) {
        return new PipelinedRedisFuture<Object>(executions, objectPipelinedRedisFuture -> {
            for (RedisFuture future : executions.values()) {
                MultiNodeExecution.execute(() -> future.get());
            }
            Iterator iterator = executions.values().iterator();
            if (iterator.hasNext()) {
                RedisFuture future;
                future = (RedisFuture)iterator.next();
                return MultiNodeExecution.execute(() -> future.get());
            }
            return null;
        });
    }

    protected static RedisFuture<String> alwaysOkOfAsync(Map<?, RedisFuture<String>> executions) {
        return new PipelinedRedisFuture<String>(executions, objectPipelinedRedisFuture -> {
            for (RedisFuture future : executions.values()) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RedisCommandInterruptedException(e);
                }
                catch (ExecutionException executionException) {
                }
            }
            return "OK";
        });
    }
}

