/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import com.lambdaworks.redis.protocol.DefaultEndpoint;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.resource.ClientResources;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;

class ClusterNodeEndpoint
extends DefaultEndpoint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ClusterNodeEndpoint.class);
    private final RedisChannelWriter clusterChannelWriter;

    public ClusterNodeEndpoint(ClientOptions clientOptions, ClientResources clientResources, RedisChannelWriter clusterChannelWriter) {
        super(clientOptions);
        this.clusterChannelWriter = clusterChannelWriter;
    }

    public void prepareClose() {
        ConnectionWatchdog connectionWatchdog;
        if (this.channel != null && (connectionWatchdog = (ConnectionWatchdog)this.channel.pipeline().get(ConnectionWatchdog.class)) != null) {
            connectionWatchdog.setReconnectSuspended(true);
        }
    }

    @Override
    public void close() {
        logger.debug("{} close()", (Object)this.logPrefix());
        if (this.clusterChannelWriter != null) {
            Collection<RedisCommand<?, ?, ?>> commands = this.shiftCommands(this.getQueue());
            this.retriggerCommands(commands);
        }
        super.close();
    }

    protected void retriggerCommands(Collection<RedisCommand<?, ?, ?>> commands) {
        for (RedisCommand<?, ?, ?> queuedCommand : commands) {
            if (queuedCommand == null || queuedCommand.isCancelled()) continue;
            try {
                this.clusterChannelWriter.write(queuedCommand);
            }
            catch (RedisException e) {
                queuedCommand.completeExceptionally(e);
            }
        }
    }

    private Collection<RedisCommand<?, ?, ?>> shiftCommands(Collection<? extends RedisCommand<?, ?, ?>> source) {
        return this.doExclusive(() -> {
            try {
                ArrayList arrayList = new ArrayList(source);
                return arrayList;
            }
            finally {
                source.clear();
            }
        });
    }
}

