/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.SocketOptions;
import com.lambdaworks.redis.cluster.ClusterTopologyRefreshOptions;
import java.util.concurrent.TimeUnit;

public class ClusterClientOptions
extends ClientOptions {
    public static final boolean DEFAULT_REFRESH_CLUSTER_VIEW = false;
    public static final long DEFAULT_REFRESH_PERIOD = 60L;
    public static final TimeUnit DEFAULT_REFRESH_PERIOD_UNIT = TimeUnit.SECONDS;
    public static final boolean DEFAULT_CLOSE_STALE_CONNECTIONS = true;
    public static final boolean DEFAULT_VALIDATE_CLUSTER_MEMBERSHIP = true;
    public static final int DEFAULT_MAX_REDIRECTS = 5;
    private final boolean validateClusterNodeMembership;
    private final int maxRedirects;
    private final ClusterTopologyRefreshOptions topologyRefreshOptions;

    protected ClusterClientOptions(Builder builder) {
        super(builder);
        this.validateClusterNodeMembership = builder.validateClusterNodeMembership;
        this.maxRedirects = builder.maxRedirects;
        ClusterTopologyRefreshOptions refreshOptions = builder.topologyRefreshOptions;
        if (refreshOptions == null) {
            refreshOptions = ClusterTopologyRefreshOptions.builder().enablePeriodicRefresh(builder.refreshClusterView).refreshPeriod(builder.refreshPeriod, builder.refreshPeriodUnit).closeStaleConnections(builder.closeStaleConnections).build();
        }
        this.topologyRefreshOptions = refreshOptions;
    }

    protected ClusterClientOptions(ClusterClientOptions original) {
        super(original);
        this.validateClusterNodeMembership = original.validateClusterNodeMembership;
        this.maxRedirects = original.maxRedirects;
        this.topologyRefreshOptions = original.topologyRefreshOptions;
    }

    public static ClusterClientOptions copyOf(ClusterClientOptions options) {
        return new ClusterClientOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ClusterClientOptions create() {
        return ClusterClientOptions.builder().build();
    }

    public boolean isRefreshClusterView() {
        return this.topologyRefreshOptions.isPeriodicRefreshEnabled();
    }

    public long getRefreshPeriod() {
        return this.topologyRefreshOptions.getRefreshPeriod();
    }

    public TimeUnit getRefreshPeriodUnit() {
        return this.topologyRefreshOptions.getRefreshPeriodUnit();
    }

    public boolean isCloseStaleConnections() {
        return this.topologyRefreshOptions.isCloseStaleConnections();
    }

    public boolean isValidateClusterNodeMembership() {
        return this.validateClusterNodeMembership;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public ClusterTopologyRefreshOptions getTopologyRefreshOptions() {
        return this.topologyRefreshOptions;
    }

    public static class Builder
    extends ClientOptions.Builder {
        private boolean refreshClusterView = false;
        private long refreshPeriod = 60L;
        private TimeUnit refreshPeriodUnit = DEFAULT_REFRESH_PERIOD_UNIT;
        private boolean closeStaleConnections = true;
        private boolean validateClusterNodeMembership = true;
        private int maxRedirects = 5;
        private ClusterTopologyRefreshOptions topologyRefreshOptions = null;

        protected Builder() {
        }

        public Builder validateClusterNodeMembership(boolean validateClusterNodeMembership) {
            this.validateClusterNodeMembership = validateClusterNodeMembership;
            return this;
        }

        public Builder maxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        public Builder topologyRefreshOptions(ClusterTopologyRefreshOptions topologyRefreshOptions) {
            this.topologyRefreshOptions = topologyRefreshOptions;
            return this;
        }

        @Override
        public Builder pingBeforeActivateConnection(boolean pingBeforeActivateConnection) {
            super.pingBeforeActivateConnection(pingBeforeActivateConnection);
            return this;
        }

        @Override
        public Builder autoReconnect(boolean autoReconnect) {
            super.autoReconnect(autoReconnect);
            return this;
        }

        @Override
        public Builder suspendReconnectOnProtocolFailure(boolean suspendReconnectOnProtocolFailure) {
            super.suspendReconnectOnProtocolFailure(suspendReconnectOnProtocolFailure);
            return this;
        }

        @Override
        public Builder cancelCommandsOnReconnectFailure(boolean cancelCommandsOnReconnectFailure) {
            super.cancelCommandsOnReconnectFailure(cancelCommandsOnReconnectFailure);
            return this;
        }

        @Override
        public Builder requestQueueSize(int requestQueueSize) {
            super.requestQueueSize(requestQueueSize);
            return this;
        }

        @Override
        public Builder disconnectedBehavior(ClientOptions.DisconnectedBehavior disconnectedBehavior) {
            super.disconnectedBehavior(disconnectedBehavior);
            return this;
        }

        @Override
        public ClientOptions.Builder socketOptions(SocketOptions socketOptions) {
            super.socketOptions(socketOptions);
            return this;
        }

        @Override
        public ClusterClientOptions build() {
            return new ClusterClientOptions(this);
        }
    }
}

