/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.CompositeArgument;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import java.util.ArrayList;
import java.util.List;

public class ZStoreArgs
implements CompositeArgument {
    private List<Double> weights;
    private Aggregate aggregate;

    @Deprecated
    public static ZStoreArgs weights(long[] weights) {
        return new ZStoreArgs().weights(ZStoreArgs.toDoubleArray(weights));
    }

    public ZStoreArgs weights(double ... weights) {
        this.weights = new ArrayList<Double>(weights.length);
        for (double weight : weights) {
            this.weights.add(weight);
        }
        return this;
    }

    public ZStoreArgs sum() {
        this.aggregate = Aggregate.SUM;
        return this;
    }

    public ZStoreArgs min() {
        this.aggregate = Aggregate.MIN;
        return this;
    }

    public ZStoreArgs max() {
        this.aggregate = Aggregate.MAX;
        return this;
    }

    private static double[] toDoubleArray(long[] weights) {
        double[] result = new double[weights.length];
        for (int i = 0; i < weights.length; ++i) {
            result[i] = weights[i];
        }
        return result;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.weights != null) {
            args.add(CommandKeyword.WEIGHTS);
            for (double weight : this.weights) {
                args.add(weight);
            }
        }
        if (this.aggregate != null) {
            args.add(CommandKeyword.AGGREGATE);
            switch (this.aggregate) {
                case SUM: {
                    args.add(CommandKeyword.SUM);
                    break;
                }
                case MIN: {
                    args.add(CommandKeyword.MIN);
                    break;
                }
                case MAX: {
                    args.add(CommandKeyword.MAX);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Aggregation " + (Object)((Object)this.aggregate) + " not supported");
                }
            }
        }
    }

    public static class Builder {
        private Builder() {
        }

        @Deprecated
        public static ZStoreArgs weights(long[] weights) {
            return new ZStoreArgs().weights(ZStoreArgs.toDoubleArray(weights));
        }

        public static ZStoreArgs weights(double ... weights) {
            return new ZStoreArgs().weights(weights);
        }

        public static ZStoreArgs sum() {
            return new ZStoreArgs().sum();
        }

        public static ZStoreArgs min() {
            return new ZStoreArgs().min();
        }

        public static ZStoreArgs max() {
            return new ZStoreArgs().max();
        }
    }

    private static enum Aggregate {
        SUM,
        MIN,
        MAX;

    }
}

