/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionBuilder;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.SslConnectionBuilder;
import com.lambdaworks.redis.StatefulRedisConnectionImpl;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.StringCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.DefaultEndpoint;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import com.lambdaworks.redis.pubsub.PubSubEndpoint;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnection;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnectionImpl;
import com.lambdaworks.redis.resource.ClientResources;
import com.lambdaworks.redis.resource.SocketAddressResolver;
import com.lambdaworks.redis.sentinel.StatefulRedisSentinelConnectionImpl;
import com.lambdaworks.redis.sentinel.api.StatefulRedisSentinelConnection;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class RedisClient
extends AbstractRedisClient {
    private static final RedisURI EMPTY_URI = new RedisURI();
    private final RedisURI redisURI;

    protected RedisClient(ClientResources clientResources, RedisURI redisURI) {
        super(clientResources);
        RedisClient.assertNotNull(redisURI);
        this.redisURI = redisURI;
        this.setDefaultTimeout(redisURI.getTimeout(), redisURI.getUnit());
    }

    protected RedisClient() {
        this(null, EMPTY_URI);
    }

    public static RedisClient create() {
        return new RedisClient(null, EMPTY_URI);
    }

    public static RedisClient create(RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return new RedisClient(null, redisURI);
    }

    public static RedisClient create(String uri) {
        LettuceAssert.notEmpty(uri, "URI must not be empty");
        return new RedisClient(null, RedisURI.create(uri));
    }

    public static RedisClient create(ClientResources clientResources) {
        RedisClient.assertNotNull(clientResources);
        return new RedisClient(clientResources, EMPTY_URI);
    }

    public static RedisClient create(ClientResources clientResources, String uri) {
        RedisClient.assertNotNull(clientResources);
        LettuceAssert.notEmpty(uri, "URI must not be empty");
        return RedisClient.create(clientResources, RedisURI.create(uri));
    }

    public static RedisClient create(ClientResources clientResources, RedisURI redisURI) {
        RedisClient.assertNotNull(clientResources);
        RedisClient.assertNotNull(redisURI);
        return new RedisClient(clientResources, redisURI);
    }

    public StatefulRedisConnection<String, String> connect() {
        return this.connect(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisConnection<K, V> connect(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectStandalone(codec, this.redisURI, this.defaultTimeout());
    }

    public StatefulRedisConnection<String, String> connect(RedisURI redisURI) {
        return this.connectStandalone(this.newStringStringCodec(), redisURI, Timeout.from(redisURI));
    }

    public <K, V> StatefulRedisConnection<K, V> connect(RedisCodec<K, V> codec, RedisURI redisURI) {
        return this.connectStandalone(codec, redisURI, Timeout.from(redisURI));
    }

    private <K, V> StatefulRedisConnection<K, V> connectStandalone(RedisCodec<K, V> codec, RedisURI redisURI, Timeout timeout) {
        RedisClient.assertNotNull(codec);
        this.checkValidRedisURI(redisURI);
        DefaultEndpoint endpoint = new DefaultEndpoint(this.clientOptions);
        StatefulRedisConnectionImpl<K, V> connection = this.newStatefulRedisConnection(endpoint, codec, timeout.timeout, timeout.timeUnit);
        this.connectStateful(connection, redisURI, endpoint, () -> new CommandHandler(this.clientResources, endpoint));
        return connection;
    }

    private <K, V> void connectStateful(StatefulRedisConnectionImpl<K, V> connection, RedisURI redisURI, DefaultEndpoint endpoint, Supplier<CommandHandler> commandHandlerSupplier) {
        ConnectionBuilder connectionBuilder;
        if (redisURI.isSsl()) {
            SslConnectionBuilder sslConnectionBuilder = SslConnectionBuilder.sslConnectionBuilder();
            sslConnectionBuilder.ssl(redisURI);
            connectionBuilder = sslConnectionBuilder;
        } else {
            connectionBuilder = ConnectionBuilder.connectionBuilder();
        }
        connectionBuilder.connection(connection);
        connectionBuilder.clientOptions(this.clientOptions);
        connectionBuilder.clientResources(this.clientResources);
        connectionBuilder.commandHandler(commandHandlerSupplier).endpoint(endpoint);
        this.connectionBuilder(this.getSocketAddressSupplier(redisURI), connectionBuilder, redisURI);
        this.channelType(connectionBuilder, redisURI);
        this.initializeChannel(connectionBuilder);
        if (redisURI.getPassword() != null && redisURI.getPassword().length != 0) {
            connection.async().auth(new String(redisURI.getPassword()));
        }
        if (redisURI.getDatabase() != 0) {
            connection.async().select(redisURI.getDatabase());
        }
    }

    public StatefulRedisPubSubConnection<String, String> connectPubSub() {
        return this.connectPubSub(this.newStringStringCodec(), this.redisURI, this.defaultTimeout());
    }

    public StatefulRedisPubSubConnection<String, String> connectPubSub(RedisURI redisURI) {
        return this.connectPubSub(this.newStringStringCodec(), redisURI, Timeout.from(redisURI));
    }

    public <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectPubSub(codec, this.redisURI, this.defaultTimeout());
    }

    public <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec, RedisURI redisURI) {
        return this.connectPubSub(codec, redisURI, Timeout.from(redisURI));
    }

    private <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec, RedisURI redisURI, Timeout timeout) {
        RedisClient.assertNotNull(codec);
        this.checkValidRedisURI(redisURI);
        PubSubEndpoint endpoint = new PubSubEndpoint(this.clientOptions);
        StatefulRedisPubSubConnectionImpl connection = this.newStatefulRedisPubSubConnection(endpoint, endpoint, codec, timeout.timeout, timeout.timeUnit);
        this.connectStateful(connection, redisURI, endpoint, () -> new PubSubCommandHandler(this.clientResources, codec, endpoint));
        return connection;
    }

    public StatefulRedisSentinelConnection<String, String> connectSentinel() {
        return this.connectSentinel(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectSentinel(codec, this.redisURI, this.defaultTimeout());
    }

    public StatefulRedisSentinelConnection<String, String> connectSentinel(RedisURI redisURI) {
        return this.connectSentinel(this.newStringStringCodec(), redisURI, Timeout.from(redisURI));
    }

    public <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec, RedisURI redisURI) {
        return this.connectSentinel(codec, redisURI, Timeout.from(redisURI));
    }

    private <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec, RedisURI redisURI, Timeout timeout) {
        RedisClient.assertNotNull(codec);
        this.checkValidRedisURI(redisURI);
        ConnectionBuilder connectionBuilder = ConnectionBuilder.connectionBuilder();
        connectionBuilder.clientOptions(ClientOptions.copyOf(this.getOptions()));
        connectionBuilder.clientResources(this.clientResources);
        DefaultEndpoint endpoint = new DefaultEndpoint(this.clientOptions);
        StatefulRedisSentinelConnectionImpl<K, V> connection = this.newStatefulRedisSentinelConnection(endpoint, codec, timeout.timeout, timeout.timeUnit);
        logger.debug("Trying to get a Sentinel connection for one of: " + redisURI.getSentinels());
        connectionBuilder.endpoint(endpoint).commandHandler(() -> new CommandHandler(this.clientResources, endpoint)).connection(connection);
        this.connectionBuilder(this.getSocketAddressSupplier(redisURI), connectionBuilder, redisURI);
        if (redisURI.getSentinels().isEmpty() && (LettuceStrings.isNotEmpty(redisURI.getHost()) || !LettuceStrings.isEmpty(redisURI.getSocket()))) {
            this.channelType(connectionBuilder, redisURI);
            this.initializeChannel(connectionBuilder);
        } else {
            boolean connected = false;
            boolean first = true;
            Exception causingException = null;
            this.validateUrisAreOfSameConnectionType(redisURI.getSentinels());
            for (RedisURI uri : redisURI.getSentinels()) {
                if (first) {
                    this.channelType(connectionBuilder, uri);
                    first = false;
                }
                connectionBuilder.socketAddressSupplier(this.getSocketAddressSupplier(uri));
                if (logger.isDebugEnabled()) {
                    SocketAddress socketAddress = SocketAddressResolver.resolve(redisURI, this.clientResources.dnsResolver());
                    logger.debug("Connecting to Sentinel, address: " + socketAddress);
                }
                try {
                    this.initializeChannel(connectionBuilder);
                    connected = true;
                    break;
                }
                catch (Exception e) {
                    logger.warn("Cannot connect sentinel at " + uri + ": " + e.toString());
                    causingException = e;
                    if (!(e instanceof ConnectException)) continue;
                }
            }
            if (!connected) {
                throw new RedisConnectionException("Cannot connect to a sentinel: " + redisURI.getSentinels(), causingException);
            }
        }
        return connection;
    }

    protected <K, V> StatefulRedisPubSubConnectionImpl<K, V> newStatefulRedisPubSubConnection(PubSubEndpoint<K, V> endpoint, RedisChannelWriter channelWriter, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        return new StatefulRedisPubSubConnectionImpl<K, V>(endpoint, channelWriter, codec, timeout, unit);
    }

    protected <K, V> StatefulRedisSentinelConnectionImpl<K, V> newStatefulRedisSentinelConnection(RedisChannelWriter channelWriter, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        return new StatefulRedisSentinelConnectionImpl<K, V>(channelWriter, codec, timeout, unit);
    }

    protected <K, V> StatefulRedisConnectionImpl<K, V> newStatefulRedisConnection(RedisChannelWriter channelWriter, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        return new StatefulRedisConnectionImpl<K, V>(channelWriter, codec, timeout, unit);
    }

    private void validateUrisAreOfSameConnectionType(List<RedisURI> redisUris) {
        boolean unixDomainSocket = false;
        boolean inetSocket = false;
        for (RedisURI sentinel : redisUris) {
            if (sentinel.getSocket() != null) {
                unixDomainSocket = true;
            }
            if (sentinel.getHost() == null) continue;
            inetSocket = true;
        }
        if (unixDomainSocket && inetSocket) {
            throw new RedisConnectionException("You cannot mix unix domain socket and IP socket URI's");
        }
    }

    private Supplier<SocketAddress> getSocketAddressSupplier(RedisURI redisURI) {
        return () -> {
            try {
                SocketAddress socketAddress = this.getSocketAddress(redisURI);
                logger.debug("Resolved SocketAddress {} using {}", (Object)socketAddress, (Object)redisURI);
                return socketAddress;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RedisCommandInterruptedException(e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new RedisException(e);
            }
        };
    }

    public ClientResources getResources() {
        return this.clientResources;
    }

    private SocketAddress getSocketAddress(RedisURI redisURI) throws InterruptedException, TimeoutException, ExecutionException {
        SocketAddress redisAddress;
        if (redisURI.getSentinelMasterId() != null && !redisURI.getSentinels().isEmpty()) {
            logger.debug("Connecting to Redis using Sentinels {}, MasterId {}", redisURI.getSentinels(), (Object)redisURI.getSentinelMasterId());
            redisAddress = this.lookupRedis(redisURI);
            if (redisAddress == null) {
                throw new RedisConnectionException("Cannot provide redisAddress using sentinel for masterId " + redisURI.getSentinelMasterId());
            }
        } else {
            redisAddress = SocketAddressResolver.resolve(redisURI, this.clientResources.dnsResolver());
        }
        return redisAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress lookupRedis(RedisURI sentinelUri) throws InterruptedException, TimeoutException, ExecutionException {
        try (StatefulRedisSentinelConnection<String, String> connection = this.connectSentinel(sentinelUri);){
            SocketAddress socketAddress = (SocketAddress)connection.async().getMasterAddrByName(sentinelUri.getSentinelMasterId()).get(this.timeout, this.unit);
            return socketAddress;
        }
    }

    private void checkValidRedisURI(RedisURI redisURI) {
        LettuceAssert.notNull(redisURI, "A valid RedisURI is needed");
        if (redisURI.getSentinels().isEmpty()) {
            if (LettuceStrings.isEmpty(redisURI.getHost()) && LettuceStrings.isEmpty(redisURI.getSocket())) {
                throw new IllegalArgumentException("RedisURI for Redis Standalone does not contain a host or a socket");
            }
        } else {
            if (LettuceStrings.isEmpty(redisURI.getSentinelMasterId())) {
                throw new IllegalArgumentException("TRedisURI for Redis Sentinel requires a masterId");
            }
            for (RedisURI sentinel : redisURI.getSentinels()) {
                if (!LettuceStrings.isEmpty(sentinel.getHost()) || !LettuceStrings.isEmpty(sentinel.getSocket())) continue;
                throw new IllegalArgumentException("RedisURI for Redis Sentinel does not contain a host or a socket");
            }
        }
    }

    protected RedisCodec<String, String> newStringStringCodec() {
        return StringCodec.UTF8;
    }

    private static <K, V> void assertNotNull(RedisCodec<K, V> codec) {
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
    }

    private static void assertNotNull(RedisURI redisURI) {
        LettuceAssert.notNull(redisURI, "RedisURI must not be null");
    }

    private static void assertNotNull(ClientResources clientResources) {
        LettuceAssert.notNull(clientResources, "ClientResources must not be null");
    }

    private void checkForRedisURI() {
        LettuceAssert.assertState(this.redisURI != EMPTY_URI, "RedisURI is not available. Use RedisClient(Host), RedisClient(Host, Port) or RedisClient(RedisURI) to construct your client.");
        this.checkValidRedisURI(this.redisURI);
    }

    @Override
    public void setOptions(ClientOptions clientOptions) {
        super.setOptions(clientOptions);
    }

    private Timeout defaultTimeout() {
        return Timeout.of(this.timeout, this.unit);
    }

    private static class Timeout {
        final long timeout;
        final TimeUnit timeUnit;

        private Timeout(long timeout, TimeUnit timeUnit) {
            this.timeout = timeout;
            this.timeUnit = timeUnit;
        }

        private static Timeout of(long timeout, TimeUnit timeUnit) {
            return new Timeout(timeout, timeUnit);
        }

        private static Timeout from(RedisURI redisURI) {
            LettuceAssert.notNull(redisURI, "A valid RedisURI is needed");
            return new Timeout(redisURI.getTimeout(), redisURI.getUnit());
        }
    }
}

