/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.CloseEvents;
import com.lambdaworks.redis.FutureSyncInvocationHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.ConnectionFacade;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public abstract class RedisChannelHandler<K, V>
implements Closeable,
ConnectionFacade {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisChannelHandler.class);
    private long timeout;
    private TimeUnit unit;
    private CloseEvents closeEvents = new CloseEvents();
    private final RedisChannelWriter channelWriter;
    private final boolean debugEnabled = logger.isDebugEnabled();
    private volatile boolean closed;
    private volatile boolean active = true;
    private volatile ClientOptions clientOptions;

    public RedisChannelHandler(RedisChannelWriter writer, long timeout, TimeUnit unit) {
        this.channelWriter = writer;
        writer.setConnectionFacade(this);
        this.setTimeout(timeout, unit);
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public synchronized void close() {
        if (this.debugEnabled) {
            logger.debug("close()");
        }
        if (this.closed) {
            logger.warn("Connection is already closed");
            return;
        }
        if (!this.closed) {
            this.active = false;
            this.closed = true;
            this.channelWriter.close();
            this.closeEvents.fireEventClosed(this);
            this.closeEvents = new CloseEvents();
        }
    }

    protected <T, C extends RedisCommand<K, V, T>> C dispatch(C cmd) {
        if (this.debugEnabled) {
            logger.debug("dispatching command {}", cmd);
        }
        return (C)this.channelWriter.write(cmd);
    }

    public void registerCloseables(Collection<Closeable> registry, Closeable ... closeables) {
        registry.addAll(Arrays.asList(closeables));
        this.addListener(resource -> {
            for (Closeable closeable : closeables) {
                if (closeable == this) continue;
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (!this.debugEnabled) continue;
                    logger.debug(e.toString(), (Throwable)e);
                }
            }
            registry.removeAll(Arrays.asList(closeables));
        });
    }

    protected void addListener(CloseEvents.CloseListener listener) {
        this.closeEvents.addListener(listener);
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void activated() {
        this.active = true;
        this.closed = false;
    }

    @Override
    public void deactivated() {
        this.active = false;
    }

    public RedisChannelWriter getChannelWriter() {
        return this.channelWriter;
    }

    public boolean isOpen() {
        return this.active;
    }

    @Override
    public void reset() {
        this.channelWriter.reset();
    }

    public ClientOptions getOptions() {
        return this.clientOptions;
    }

    public void setOptions(ClientOptions clientOptions) {
        LettuceAssert.notNull(clientOptions, "ClientOptions must not be null");
        this.clientOptions = clientOptions;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.unit;
    }

    protected <T> T syncHandler(Object asyncApi, Class<?> ... interfaces) {
        FutureSyncInvocationHandler h = new FutureSyncInvocationHandler((StatefulConnection)((Object)this), asyncApi, interfaces);
        return (T)Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), interfaces, h);
    }

    public void setAutoFlushCommands(boolean autoFlush) {
        this.getChannelWriter().setAutoFlushCommands(autoFlush);
    }

    public void flushCommands() {
        this.getChannelWriter().flushCommands();
    }
}

