/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.CompositeArgument;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;

public class KillArgs
implements CompositeArgument {
    private Boolean skipme;
    private String addr;
    private Long id;
    private Type type;

    public KillArgs skipme() {
        return this.skipme(true);
    }

    public KillArgs skipme(boolean state) {
        this.skipme = state;
        return this;
    }

    public KillArgs addr(String addr) {
        this.addr = addr;
        return this;
    }

    public KillArgs id(long id) {
        this.id = id;
        return this;
    }

    public KillArgs type(Type type) {
        this.type = type;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.skipme != null) {
            args.add(CommandKeyword.SKIPME).add(this.skipme != false ? "yes" : "no");
        }
        if (this.id != null) {
            args.add(CommandKeyword.ID).add(this.id);
        }
        if (this.addr != null) {
            args.add(CommandKeyword.ADDR).add(this.addr);
        }
        if (this.type != null) {
            args.add(CommandType.TYPE).add(this.type.name().toLowerCase());
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static KillArgs skipme() {
            return new KillArgs().skipme();
        }

        public static KillArgs addr(String addr) {
            return new KillArgs().addr(addr);
        }

        public static KillArgs id(long id) {
            return new KillArgs().id(id);
        }

        public static KillArgs typePubsub() {
            return new KillArgs().type(Type.PUBSUB);
        }

        public static KillArgs typeNormal() {
            return new KillArgs().type(Type.NORMAL);
        }

        public static KillArgs typeSlave() {
            return new KillArgs().type(Type.SLAVE);
        }
    }

    private static enum Type {
        NORMAL,
        SLAVE,
        PUBSUB;

    }
}

