/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.Value;
import com.lambdaworks.redis.internal.LettuceAssert;
import java.util.Optional;
import java.util.function.Function;

public class KeyValue<K, V>
extends Value<V> {
    private final K key;

    protected KeyValue() {
        super(null);
        this.key = null;
    }

    private KeyValue(K key, V value) {
        super(value);
        LettuceAssert.notNull(key, "Key must not be null");
        this.key = key;
    }

    public static <K, T extends V, V> KeyValue<K, V> from(K key, Optional<T> optional) {
        LettuceAssert.notNull(optional, "Optional must not be null");
        if (optional.isPresent()) {
            return new KeyValue<K, T>(key, optional.get());
        }
        return KeyValue.empty(key);
    }

    public static <K, T extends V, V> KeyValue<K, V> fromNullable(K key, T value) {
        if (value == null) {
            return KeyValue.empty(key);
        }
        return new KeyValue<K, T>(key, value);
    }

    public static <K, V> KeyValue<K, V> empty(K key) {
        return new KeyValue<K, Object>(key, null);
    }

    public static <K, T extends V, V> KeyValue<K, V> just(K key, T value) {
        LettuceAssert.notNull(value, "Value must not be null");
        return new KeyValue<K, T>(key, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyValue keyValue = (KeyValue)o;
        return this.key.equals(keyValue.key);
    }

    @Override
    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.hasValue() ? this.getValue().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return this.hasValue() ? String.format("KeyValue[%s, %s]", this.key, this.getValue()) : String.format("KeyValue[%s].empty", this.key);
    }

    public K getKey() {
        return this.key;
    }

    public <R> KeyValue<K, R> map(Function<? super V, ? extends R> mapper) {
        LettuceAssert.notNull(mapper, "Mapper function must not be null");
        if (this.hasValue()) {
            return new KeyValue<K, R>(this.getKey(), mapper.apply(this.getValue()));
        }
        return this;
    }
}

