/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisConnectionStateListener;
import io.netty.util.internal.ConcurrentSet;
import java.util.Set;

public class ConnectionEvents {
    private final Set<RedisConnectionStateListener> listeners = new ConcurrentSet();

    protected void fireEventRedisConnected(RedisChannelHandler<?, ?> connection) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisConnected(connection);
        }
    }

    protected void fireEventRedisDisconnected(RedisChannelHandler<?, ?> connection) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisDisconnected(connection);
        }
    }

    protected void fireEventRedisExceptionCaught(RedisChannelHandler<?, ?> connection, Throwable cause) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisExceptionCaught(connection, cause);
        }
    }

    public void addListener(RedisConnectionStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        this.listeners.remove(listener);
    }

    public static class Reconnect {
        private final int attempt;

        public Reconnect(int attempt) {
            this.attempt = attempt;
        }

        public int getAttempt() {
            return this.attempt;
        }
    }

    public static class Activated {
    }

    public static class Reset {
    }
}

