/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNodeVisitor;
import org.aspectj.weaver.patterns.Pointcut;

public class NotPointcut
extends Pointcut {
    private Pointcut body;

    public NotPointcut(Pointcut negated) {
        this.body = negated;
        this.pointcutKind = (byte)7;
    }

    public NotPointcut(Pointcut pointcut, int startPos) {
        this(pointcut);
        this.setLocation(pointcut.getSourceContext(), startPos, pointcut.getEnd());
    }

    public int couldMatchKinds() {
        return Shadow.ALL_SHADOW_KINDS_BITS;
    }

    public Pointcut getNegatedPointcut() {
        return this.body;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return this.body.fastMatch(type).not();
    }

    protected FuzzyBoolean matchInternal(Shadow shadow) {
        return this.body.match(shadow).not();
    }

    public String toString() {
        return "!" + this.body.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof NotPointcut)) {
            return false;
        }
        NotPointcut o = (NotPointcut)other;
        return o.body.equals(this.body);
    }

    public int hashCode() {
        return 851 + this.body.hashCode();
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        this.body.resolveBindings(scope, null);
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(7);
        this.body.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        NotPointcut ret = new NotPointcut(Pointcut.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    protected Test findResidueInternal(Shadow shadow, ExposedState state) {
        return Test.makeNot(this.body.findResidue(shadow, state));
    }

    public Pointcut concretize1(ResolvedType inAspect, ResolvedType declaringType, IntMap bindings) {
        NotPointcut ret = new NotPointcut(this.body.concretize(inAspect, declaringType, bindings));
        ret.copyLocationFrom(this);
        return ret;
    }

    public Pointcut parameterizeWith(Map typeVariableMap) {
        NotPointcut ret = new NotPointcut(this.body.parameterizeWith(typeVariableMap));
        ret.copyLocationFrom(this);
        return ret;
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object traverse(PatternNodeVisitor visitor, Object data) {
        Object ret = this.accept(visitor, data);
        this.body.traverse(visitor, ret);
        return ret;
    }
}

