/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.generic.ANEWARRAY;
import org.aspectj.apache.bcel.generic.BranchInstruction;
import org.aspectj.apache.bcel.generic.CPInstruction;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.FieldGen;
import org.aspectj.apache.bcel.generic.FieldInstruction;
import org.aspectj.apache.bcel.generic.GOTO;
import org.aspectj.apache.bcel.generic.GOTO_W;
import org.aspectj.apache.bcel.generic.INVOKESPECIAL;
import org.aspectj.apache.bcel.generic.IndexedInstruction;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.InstructionTargeter;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.LineNumberTag;
import org.aspectj.apache.bcel.generic.LocalVariableInstruction;
import org.aspectj.apache.bcel.generic.LocalVariableTag;
import org.aspectj.apache.bcel.generic.MONITORENTER;
import org.aspectj.apache.bcel.generic.MONITOREXIT;
import org.aspectj.apache.bcel.generic.MULTIANEWARRAY;
import org.aspectj.apache.bcel.generic.MethodGen;
import org.aspectj.apache.bcel.generic.NEW;
import org.aspectj.apache.bcel.generic.NEWARRAY;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.PUTFIELD;
import org.aspectj.apache.bcel.generic.PUTSTATIC;
import org.aspectj.apache.bcel.generic.RET;
import org.aspectj.apache.bcel.generic.ReturnInstruction;
import org.aspectj.apache.bcel.generic.Select;
import org.aspectj.apache.bcel.generic.Tag;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.generic.annotation.AnnotationGen;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.WeaveMessage;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.bridge.context.ContextToken;
import org.aspectj.util.PartialOrder;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.AsmRelationshipProvider;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.IClassWeaver;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MissingResolvedTypeWithKnownSignature;
import org.aspectj.weaver.NewConstructorTypeMunger;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.NewMethodTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.WeaverMetrics;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.bcel.BcelAdvice;
import org.aspectj.weaver.bcel.BcelField;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelShadow;
import org.aspectj.weaver.bcel.BcelTypeMunger;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.ExceptionRange;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.bcel.Range;
import org.aspectj.weaver.bcel.ShadowRange;
import org.aspectj.weaver.bcel.Utility;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.ExactTypePattern;

class BcelClassWeaver
implements IClassWeaver {
    private final LazyClassGen clazz;
    private final List shadowMungers;
    private final List typeMungers;
    private final List lateTypeMungers;
    private final BcelObjectType ty;
    private final BcelWorld world;
    private final ConstantPoolGen cpg;
    private final InstructionFactory fact;
    private final List addedLazyMethodGens = new ArrayList();
    private final Set addedDispatchTargets = new HashSet();
    private static boolean inReweavableMode = false;
    private List addedSuperInitializersAsList = null;
    private final Map addedSuperInitializers = new HashMap();
    private List addedThisInitializers = new ArrayList();
    private List addedClassInitializers = new ArrayList();
    private Map mapToAnnotations = new HashMap();
    private BcelShadow clinitShadow = null;
    private final List initializationShadows = new ArrayList(1);
    private List[] perKindShadowMungers;
    private boolean canMatchBodyShadows = false;
    private boolean canMatchInitialization = false;
    private static boolean checkedXsetForLowLevelContextCapturing = false;
    private static boolean captureLowLevelContext = false;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$NoClassDefFoundError;
    static /* synthetic */ Class class$java$lang$ClassNotFoundException;

    public static boolean weave(BcelWorld world, LazyClassGen clazz, List shadowMungers, List typeMungers, List lateTypeMungers) {
        boolean b = new BcelClassWeaver(world, clazz, shadowMungers, typeMungers, lateTypeMungers).weave();
        return b;
    }

    private BcelClassWeaver(BcelWorld world, LazyClassGen clazz, List shadowMungers, List typeMungers, List lateTypeMungers) {
        this.world = world;
        this.clazz = clazz;
        this.shadowMungers = shadowMungers;
        this.typeMungers = typeMungers;
        this.lateTypeMungers = lateTypeMungers;
        this.ty = clazz.getBcelObjectType();
        this.cpg = clazz.getConstantPoolGen();
        this.fact = clazz.getFactory();
        this.fastMatchShadowMungers(shadowMungers);
        this.initializeSuperInitializerMap(this.ty.getResolvedTypeX());
        if (!checkedXsetForLowLevelContextCapturing) {
            String s;
            Properties p = world.getExtraConfiguration();
            if (p != null && (captureLowLevelContext = (s = p.getProperty("captureAllContext", "false")).equalsIgnoreCase("true"))) {
                world.getMessageHandler().handleMessage(MessageUtil.info("[captureAllContext=true] Enabling collection of low level context for debug/crash messages"));
            }
            checkedXsetForLowLevelContextCapturing = true;
        }
    }

    private void fastMatchShadowMungers(List shadowMungers) {
        this.perKindShadowMungers = new List[14];
        for (int i = 0; i < this.perKindShadowMungers.length; ++i) {
            this.perKindShadowMungers[i] = new ArrayList(0);
        }
        Iterator iter = shadowMungers.iterator();
        while (iter.hasNext()) {
            ShadowMunger munger = (ShadowMunger)iter.next();
            int couldMatchKinds = munger.getPointcut().couldMatchKinds();
            for (int i = 0; i < Shadow.SHADOW_KINDS.length; ++i) {
                Shadow.Kind kind = Shadow.SHADOW_KINDS[i];
                if (!kind.isSet(couldMatchKinds)) continue;
                this.perKindShadowMungers[kind.getKey()].add(munger);
            }
        }
        if (!this.perKindShadowMungers[Shadow.Initialization.getKey()].isEmpty()) {
            this.canMatchInitialization = true;
        }
        for (int i = 0; i < Shadow.SHADOW_KINDS.length; ++i) {
            Shadow.Kind kind = Shadow.SHADOW_KINDS[i];
            if (!kind.isEnclosingKind() && !this.perKindShadowMungers[i + 1].isEmpty()) {
                this.canMatchBodyShadows = true;
            }
            if (!this.perKindShadowMungers[i + 1].isEmpty()) continue;
            this.perKindShadowMungers[i + 1] = null;
        }
    }

    private boolean canMatch(Shadow.Kind kind) {
        return this.perKindShadowMungers[kind.getKey()] != null;
    }

    private void initializeSuperInitializerMap(ResolvedType child) {
        ResolvedType[] superInterfaces = child.getDeclaredInterfaces();
        int len = superInterfaces.length;
        for (int i = 0; i < len; ++i) {
            if (!this.ty.getResolvedTypeX().isTopmostImplementor(superInterfaces[i]) || !this.addSuperInitializer(superInterfaces[i])) continue;
            this.initializeSuperInitializerMap(superInterfaces[i]);
        }
    }

    private boolean addSuperInitializer(ResolvedType onType) {
        IfaceInitList l;
        if (onType.isRawType() || onType.isParameterizedType()) {
            onType = onType.getGenericType();
        }
        if ((l = (IfaceInitList)this.addedSuperInitializers.get(onType)) != null) {
            return false;
        }
        l = new IfaceInitList(onType);
        this.addedSuperInitializers.put(onType, l);
        return true;
    }

    public void addInitializer(ConcreteTypeMunger cm) {
        NewFieldTypeMunger m = (NewFieldTypeMunger)cm.getMunger();
        ResolvedType onType = m.getSignature().getDeclaringType().resolve(this.world);
        if (onType.isRawType()) {
            onType = onType.getGenericType();
        }
        if (m.getSignature().isStatic()) {
            this.addedClassInitializers.add(cm);
        } else if (onType == this.ty.getResolvedTypeX()) {
            this.addedThisInitializers.add(cm);
        } else {
            IfaceInitList l = (IfaceInitList)this.addedSuperInitializers.get(onType);
            l.list.add(cm);
        }
    }

    public boolean addDispatchTarget(ResolvedMember m) {
        return this.addedDispatchTargets.add(m);
    }

    public void addLazyMethodGen(LazyMethodGen gen) {
        this.addedLazyMethodGens.add(gen);
    }

    public void addOrReplaceLazyMethodGen(LazyMethodGen mg) {
        if (this.alreadyDefined(this.clazz, mg)) {
            return;
        }
        Iterator i = this.addedLazyMethodGens.iterator();
        while (i.hasNext()) {
            LazyMethodGen existing = (LazyMethodGen)i.next();
            if (!this.signaturesMatch(mg, existing)) continue;
            if (existing.definingType == null) {
                return;
            }
            if (mg.definingType.isAssignableFrom(existing.definingType)) {
                return;
            }
            if (existing.definingType.isAssignableFrom(mg.definingType)) {
                i.remove();
                this.addedLazyMethodGens.add(mg);
                return;
            }
            throw new BCException("conflict between: " + mg + " and " + existing);
        }
        this.addedLazyMethodGens.add(mg);
    }

    private boolean alreadyDefined(LazyClassGen clazz, LazyMethodGen mg) {
        Iterator i = clazz.getMethodGens().iterator();
        while (i.hasNext()) {
            LazyMethodGen existing = (LazyMethodGen)i.next();
            if (!this.signaturesMatch(mg, existing)) continue;
            if (!mg.isAbstract() && existing.isAbstract()) {
                i.remove();
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean signaturesMatch(LazyMethodGen mg, LazyMethodGen existing) {
        return mg.getName().equals(existing.getName()) && mg.getSignature().equals(existing.getSignature());
    }

    protected static LazyMethodGen makeBridgeMethod(LazyClassGen gen, ResolvedMember member) {
        int mods = member.getModifiers();
        if (Modifier.isAbstract(mods)) {
            mods -= 1024;
        }
        LazyMethodGen ret = new LazyMethodGen(mods, BcelWorld.makeBcelType(member.getReturnType()), member.getName(), BcelWorld.makeBcelTypes(member.getParameterTypes()), UnresolvedType.getNames(member.getExceptions()), gen);
        return ret;
    }

    private static void createBridgeMethod(BcelWorld world, LazyMethodGen whatToBridgeToMethodGen, LazyClassGen clazz, ResolvedMember theBridgeMethod) {
        int pos = 0;
        ResolvedMemberImpl whatToBridgeTo = whatToBridgeToMethodGen.getMemberView();
        if (whatToBridgeTo == null) {
            whatToBridgeTo = new ResolvedMemberImpl(Member.METHOD, whatToBridgeToMethodGen.getEnclosingClass().getType(), whatToBridgeToMethodGen.getAccessFlags(), whatToBridgeToMethodGen.getName(), whatToBridgeToMethodGen.getSignature());
        }
        LazyMethodGen bridgeMethod = BcelClassWeaver.makeBridgeMethod(clazz, theBridgeMethod);
        bridgeMethod.setAccessFlags(bridgeMethod.getAccessFlags() | 0x40);
        Type returnType = BcelWorld.makeBcelType(theBridgeMethod.getReturnType());
        Type[] paramTypes = BcelWorld.makeBcelTypes(theBridgeMethod.getParameterTypes());
        Type[] newParamTypes = whatToBridgeToMethodGen.getArgumentTypes();
        InstructionList body = bridgeMethod.getBody();
        InstructionFactory fact = clazz.getFactory();
        if (!whatToBridgeToMethodGen.isStatic()) {
            body.append(InstructionFactory.createThis());
            ++pos;
        }
        int len = paramTypes.length;
        for (int i = 0; i < len; ++i) {
            Type paramType = paramTypes[i];
            body.append(InstructionFactory.createLoad(paramType, pos));
            if (!newParamTypes[i].equals(paramTypes[i])) {
                if (world.forDEBUG_bridgingCode) {
                    System.err.println("Bridging: Cast " + newParamTypes[i] + " from " + paramTypes[i]);
                }
                body.append(fact.createCast(paramTypes[i], newParamTypes[i]));
            }
            pos += paramType.getSize();
        }
        body.append(Utility.createInvoke(fact, world, (Member)whatToBridgeTo));
        body.append(InstructionFactory.createReturn(returnType));
        clazz.addMethodGen(bridgeMethod);
    }

    public boolean weave() {
        if (this.clazz.isWoven() && !this.clazz.isReweavable()) {
            this.world.showMessage(IMessage.ERROR, WeaverMessages.format("alreadyWoven", this.clazz.getType().getName()), this.ty.getSourceLocation(), null);
            return false;
        }
        HashSet<String> aspectsAffectingType = null;
        if (inReweavableMode || this.clazz.getType().isAspect()) {
            aspectsAffectingType = new HashSet<String>();
        }
        boolean isChanged = false;
        if (this.clazz.getType().isAspect()) {
            isChanged = true;
        }
        Iterator i = this.typeMungers.iterator();
        while (i.hasNext()) {
            BcelTypeMunger munger;
            boolean typeMungerAffectedType;
            Object o = i.next();
            if (!(o instanceof BcelTypeMunger) || !(typeMungerAffectedType = (munger = (BcelTypeMunger)o).munge(this))) continue;
            isChanged = true;
            if (!inReweavableMode && !this.clazz.getType().isAspect()) continue;
            aspectsAffectingType.add(munger.getAspectType().getName());
        }
        isChanged = this.weaveDeclareAtMethodCtor(this.clazz) || isChanged;
        isChanged = this.weaveDeclareAtField(this.clazz) || isChanged;
        this.addedSuperInitializersAsList = new ArrayList(this.addedSuperInitializers.values());
        this.addedSuperInitializersAsList = PartialOrder.sort(this.addedSuperInitializersAsList);
        if (this.addedSuperInitializersAsList == null) {
            throw new BCException("circularity in inter-types");
        }
        LazyMethodGen staticInit = this.clazz.getStaticInitializer();
        staticInit.getBody().insert(this.genInitInstructions(this.addedClassInitializers, true));
        ArrayList methodGens = new ArrayList(this.clazz.getMethodGens());
        Iterator i2 = methodGens.iterator();
        while (i2.hasNext()) {
            boolean shadowMungerMatched;
            LazyMethodGen mg = (LazyMethodGen)i2.next();
            if (!mg.hasBody()) continue;
            if (this.world.isJoinpointSynchronizationEnabled() && this.world.areSynchronizationPointcutsInUse() && mg.getMethod().isSynchronized()) {
                BcelClassWeaver.transformSynchronizedMethod(mg);
            }
            if (!(shadowMungerMatched = this.match(mg))) continue;
            if (inReweavableMode || this.clazz.getType().isAspect()) {
                aspectsAffectingType.addAll(this.findAspectsForMungers(mg));
            }
            isChanged = true;
        }
        i2 = methodGens.iterator();
        while (i2.hasNext()) {
            LazyMethodGen mg = (LazyMethodGen)i2.next();
            if (!mg.hasBody()) continue;
            this.implement(mg);
        }
        if (!this.initializationShadows.isEmpty()) {
            while (this.inlineSelfConstructors(methodGens)) {
            }
            this.positionAndImplement(this.initializationShadows);
        }
        if (this.lateTypeMungers != null) {
            i2 = this.lateTypeMungers.iterator();
            while (i2.hasNext()) {
                boolean typeMungerAffectedType;
                BcelTypeMunger munger = (BcelTypeMunger)i2.next();
                if (!munger.matches(this.clazz.getType()) || !(typeMungerAffectedType = munger.munge(this))) continue;
                isChanged = true;
                if (!inReweavableMode && !this.clazz.getType().isAspect()) continue;
                aspectsAffectingType.add(munger.getAspectType().getName());
            }
        }
        if (isChanged) {
            this.clazz.getOrCreateWeaverStateInfo(inReweavableMode);
            this.weaveInAddedMethods();
        }
        if (inReweavableMode) {
            WeaverStateInfo wsi = this.clazz.getOrCreateWeaverStateInfo(true);
            wsi.addAspectsAffectingType(aspectsAffectingType);
            wsi.setUnwovenClassFileData(this.ty.getJavaClass().getBytes());
            wsi.setReweavable(true);
        } else {
            this.clazz.getOrCreateWeaverStateInfo(false).setReweavable(false);
        }
        return isChanged;
    }

    private static ResolvedMember isOverriding(ResolvedType typeToCheck, ResolvedMember methodThatMightBeGettingOverridden, String mname, String mrettype, int mmods, boolean inSamePackage, UnresolvedType[] methodParamsArray) {
        if (methodThatMightBeGettingOverridden.isStatic()) {
            return null;
        }
        if (methodThatMightBeGettingOverridden.isPrivate()) {
            return null;
        }
        if (!methodThatMightBeGettingOverridden.getName().equals(mname)) {
            return null;
        }
        if (methodThatMightBeGettingOverridden.getParameterTypes().length != methodParamsArray.length) {
            return null;
        }
        if (!BcelClassWeaver.isVisibilityOverride(mmods, methodThatMightBeGettingOverridden, inSamePackage)) {
            return null;
        }
        if (typeToCheck.getWorld().forDEBUG_bridgingCode) {
            System.err.println("  Bridging:seriously considering this might be getting overridden '" + methodThatMightBeGettingOverridden + "'");
        }
        boolean sameParams = true;
        for (int p = 0; p < methodThatMightBeGettingOverridden.getParameterTypes().length; ++p) {
            if (methodThatMightBeGettingOverridden.getParameterTypes()[p].getErasureSignature().equals(methodParamsArray[p].getErasureSignature())) continue;
            sameParams = false;
        }
        if (sameParams) {
            ResolvedType subReturn;
            ResolvedType superReturn;
            if (typeToCheck.isParameterizedType()) {
                return methodThatMightBeGettingOverridden.getBackingGenericMember();
            }
            if (!methodThatMightBeGettingOverridden.getReturnType().getErasureSignature().equals(mrettype) && (superReturn = typeToCheck.getWorld().resolve(UnresolvedType.forSignature(methodThatMightBeGettingOverridden.getReturnType().getErasureSignature()))).isAssignableFrom(subReturn = typeToCheck.getWorld().resolve(UnresolvedType.forSignature(mrettype)))) {
                return methodThatMightBeGettingOverridden;
            }
        }
        return null;
    }

    static boolean isVisibilityOverride(int methodMods, ResolvedMember inheritedMethod, boolean inSamePackage) {
        boolean isPackageVisible;
        if (inheritedMethod.isStatic()) {
            return false;
        }
        if (methodMods == inheritedMethod.getModifiers()) {
            return true;
        }
        if (inheritedMethod.isPrivate()) {
            return false;
        }
        boolean bl = isPackageVisible = !inheritedMethod.isPrivate() && !inheritedMethod.isProtected() && !inheritedMethod.isPublic();
        return !isPackageVisible || inSamePackage;
    }

    public static ResolvedMember checkForOverride(ResolvedType typeToCheck, String mname, String mparams, String mrettype, int mmods, String mpkg, UnresolvedType[] methodParamsArray) {
        String packageName;
        if (typeToCheck == null) {
            return null;
        }
        if (typeToCheck instanceof MissingResolvedTypeWithKnownSignature) {
            return null;
        }
        if (typeToCheck.getWorld().forDEBUG_bridgingCode) {
            System.err.println("  Bridging:checking for override of " + mname + " in " + typeToCheck);
        }
        if ((packageName = typeToCheck.getPackageName()) == null) {
            packageName = "";
        }
        boolean inSamePackage = packageName.equals(mpkg);
        ResolvedMember[] methods = typeToCheck.getDeclaredMethods();
        for (int ii = 0; ii < methods.length; ++ii) {
            ResolvedMember methodThatMightBeGettingOverridden = methods[ii];
            ResolvedMember isOverriding = BcelClassWeaver.isOverriding(typeToCheck, methodThatMightBeGettingOverridden, mname, mrettype, mmods, inSamePackage, methodParamsArray);
            if (isOverriding == null) continue;
            return isOverriding;
        }
        List l = typeToCheck.getInterTypeMungers();
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            ResolvedMember aMethod;
            ResolvedMember isOverriding;
            BcelTypeMunger element;
            Object o = iterator.next();
            if (!(o instanceof BcelTypeMunger) || !((element = (BcelTypeMunger)o).getMunger() instanceof NewMethodTypeMunger)) continue;
            if (typeToCheck.getWorld().forDEBUG_bridgingCode) {
                System.err.println("Possible ITD candidate " + element);
            }
            if ((isOverriding = BcelClassWeaver.isOverriding(typeToCheck, aMethod = element.getSignature(), mname, mrettype, mmods, inSamePackage, methodParamsArray)) == null) continue;
            return isOverriding;
        }
        if (typeToCheck.equals(UnresolvedType.OBJECT)) {
            return null;
        }
        ResolvedType superclass = typeToCheck.getSuperclass();
        ResolvedMember overriddenMethod = BcelClassWeaver.checkForOverride(superclass, mname, mparams, mrettype, mmods, mpkg, methodParamsArray);
        if (overriddenMethod != null) {
            return overriddenMethod;
        }
        ResolvedType[] interfaces = typeToCheck.getDeclaredInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ResolvedType anInterface = interfaces[i];
            overriddenMethod = BcelClassWeaver.checkForOverride(anInterface, mname, mparams, mrettype, mmods, mpkg, methodParamsArray);
            if (overriddenMethod == null) continue;
            return overriddenMethod;
        }
        return null;
    }

    public static boolean calculateAnyRequiredBridgeMethods(BcelWorld world, LazyClassGen clazz) {
        int i;
        world.ensureAdvancedConfigurationProcessed();
        if (!world.isInJava5Mode()) {
            return false;
        }
        if (clazz.isInterface()) {
            return false;
        }
        boolean didSomething = false;
        List methods = clazz.getMethodGens();
        HashSet<String> methodsSet = new HashSet<String>();
        for (i = 0; i < methods.size(); ++i) {
            LazyMethodGen aMethod = (LazyMethodGen)methods.get(i);
            methodsSet.add(aMethod.getName() + aMethod.getSignature());
        }
        for (i = 0; i < methods.size(); ++i) {
            boolean alreadyHaveABridgeMethod;
            LazyMethodGen bridgeToCandidate = (LazyMethodGen)methods.get(i);
            if (bridgeToCandidate.isBridgeMethod()) continue;
            String name = bridgeToCandidate.getName();
            String psig = bridgeToCandidate.getParameterSignature();
            String rsig = bridgeToCandidate.getReturnType().getSignature();
            if (bridgeToCandidate.isStatic() || name.endsWith("init>")) continue;
            if (world.forDEBUG_bridgingCode) {
                System.err.println("Bridging: Determining if we have to bridge to " + clazz.getName() + "." + name + "" + bridgeToCandidate.getSignature());
            }
            ResolvedType theSuperclass = clazz.getSuperClass();
            if (world.forDEBUG_bridgingCode) {
                System.err.println("Bridging: Checking supertype " + theSuperclass);
            }
            String pkgName = clazz.getPackageName();
            UnresolvedType[] bm = BcelWorld.fromBcel(bridgeToCandidate.getArgumentTypes());
            ResolvedMember overriddenMethod = BcelClassWeaver.checkForOverride(theSuperclass, name, psig, rsig, bridgeToCandidate.getAccessFlags(), pkgName, bm);
            if (overriddenMethod != null && !(alreadyHaveABridgeMethod = methodsSet.contains(overriddenMethod.getName() + overriddenMethod.getSignature()))) {
                if (world.forDEBUG_bridgingCode) {
                    System.err.println("Bridging:bridging to '" + overriddenMethod + "'");
                }
                BcelClassWeaver.createBridgeMethod(world, bridgeToCandidate, clazz, overriddenMethod);
                didSomething = true;
                continue;
            }
            String[] interfaces = clazz.getInterfaceNames();
            for (int j = 0; j < interfaces.length; ++j) {
                boolean alreadyHaveABridgeMethod2;
                ResolvedType interfaceType;
                if (world.forDEBUG_bridgingCode) {
                    System.err.println("Bridging:checking superinterface " + interfaces[j]);
                }
                if ((overriddenMethod = BcelClassWeaver.checkForOverride(interfaceType = world.resolve(interfaces[j]), name, psig, rsig, bridgeToCandidate.getAccessFlags(), clazz.getPackageName(), bm)) == null || (alreadyHaveABridgeMethod2 = methodsSet.contains(overriddenMethod.getName() + overriddenMethod.getSignature()))) continue;
                BcelClassWeaver.createBridgeMethod(world, bridgeToCandidate, clazz, overriddenMethod);
                didSomething = true;
                if (!world.forDEBUG_bridgingCode) continue;
                System.err.println("Bridging:bridging to " + overriddenMethod);
            }
        }
        return didSomething;
    }

    private boolean weaveDeclareAtMethodCtor(LazyClassGen clazz) {
        ArrayList reportedProblems = new ArrayList();
        List allDecams = this.world.getDeclareAnnotationOnMethods();
        if (allDecams.isEmpty()) {
            return false;
        }
        boolean isChanged = false;
        List itdMethodsCtors = this.getITDSubset(clazz, ResolvedTypeMunger.Method);
        itdMethodsCtors.addAll(this.getITDSubset(clazz, ResolvedTypeMunger.Constructor));
        if (!itdMethodsCtors.isEmpty()) {
            isChanged = this.weaveAtMethodOnITDSRepeatedly(allDecams, itdMethodsCtors, reportedProblems);
        }
        List members = clazz.getMethodGens();
        List decaMs = this.getMatchingSubset(allDecams, clazz.getType());
        if (decaMs.isEmpty()) {
            return false;
        }
        if (!members.isEmpty()) {
            HashSet unusedDecams = new HashSet();
            unusedDecams.addAll(decaMs);
            for (int memberCounter = 0; memberCounter < members.size(); ++memberCounter) {
                Object a;
                LazyMethodGen mg = (LazyMethodGen)members.get(memberCounter);
                if (mg.getName().startsWith("ajc$")) continue;
                ArrayList<DeclareAnnotation> worthRetrying = new ArrayList<DeclareAnnotation>();
                boolean modificationOccured = false;
                ArrayList<AnnotationGen> annotationsToAdd = null;
                Iterator iter = decaMs.iterator();
                while (iter.hasNext()) {
                    DeclareAnnotation decaM = (DeclareAnnotation)iter.next();
                    if (decaM.matches(mg.getMemberView(), this.world)) {
                        if (this.doesAlreadyHaveAnnotation(mg.getMemberView(), decaM, reportedProblems)) {
                            unusedDecams.remove(decaM);
                            continue;
                        }
                        if (annotationsToAdd == null) {
                            annotationsToAdd = new ArrayList<AnnotationGen>();
                        }
                        Annotation a2 = decaM.getAnnotationX().getBcelAnnotation();
                        AnnotationGen ag = new AnnotationGen(a2, clazz.getConstantPoolGen(), true);
                        annotationsToAdd.add(ag);
                        mg.addAnnotation(decaM.getAnnotationX());
                        AsmRelationshipProvider.getDefault().addDeclareAnnotationRelationship(decaM.getSourceLocation(), clazz.getName(), mg.getMethod());
                        this.reportMethodCtorWeavingMessage(clazz, mg.getMemberView(), decaM, mg.getDeclarationLineNumber());
                        isChanged = true;
                        modificationOccured = true;
                        unusedDecams.remove(decaM);
                        continue;
                    }
                    if (decaM.isStarredAnnotationPattern()) continue;
                    worthRetrying.add(decaM);
                }
                while (!worthRetrying.isEmpty() && modificationOccured) {
                    modificationOccured = false;
                    ArrayList<DeclareAnnotation> forRemoval = new ArrayList<DeclareAnnotation>();
                    Iterator iter2 = worthRetrying.iterator();
                    while (iter2.hasNext()) {
                        DeclareAnnotation decaM = (DeclareAnnotation)iter2.next();
                        if (!decaM.matches(mg.getMemberView(), this.world)) continue;
                        if (this.doesAlreadyHaveAnnotation(mg.getMemberView(), decaM, reportedProblems)) {
                            unusedDecams.remove(decaM);
                            continue;
                        }
                        if (annotationsToAdd == null) {
                            annotationsToAdd = new ArrayList();
                        }
                        a = decaM.getAnnotationX().getBcelAnnotation();
                        AnnotationGen ag = new AnnotationGen((Annotation)a, clazz.getConstantPoolGen(), true);
                        annotationsToAdd.add(ag);
                        mg.addAnnotation(decaM.getAnnotationX());
                        AsmRelationshipProvider.getDefault().addDeclareAnnotationRelationship(decaM.getSourceLocation(), clazz.getName(), mg.getMethod());
                        isChanged = true;
                        modificationOccured = true;
                        forRemoval.add(decaM);
                        unusedDecams.remove(decaM);
                    }
                    worthRetrying.removeAll(forRemoval);
                }
                if (annotationsToAdd == null) continue;
                Method oldMethod = mg.getMethod();
                MethodGen myGen = new MethodGen(oldMethod, clazz.getClassName(), clazz.getConstantPoolGen(), false);
                Iterator iter3 = annotationsToAdd.iterator();
                while (iter3.hasNext()) {
                    a = (AnnotationGen)iter3.next();
                    myGen.addAnnotation((AnnotationGen)a);
                }
                Method newMethod = myGen.getMethod();
                members.set(memberCounter, new LazyMethodGen(newMethod, clazz));
            }
            this.checkUnusedDeclareAtTypes(unusedDecams, false);
        }
        return isChanged;
    }

    private void reportMethodCtorWeavingMessage(LazyClassGen clazz, ResolvedMember member, DeclareAnnotation decaM, int memberLineNumber) {
        if (!this.getWorld().getMessageHandler().isIgnoring(IMessage.WEAVEINFO)) {
            StringBuffer parmString = new StringBuffer("(");
            UnresolvedType[] paramTypes = member.getParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                UnresolvedType type = paramTypes[i];
                String s = org.aspectj.apache.bcel.classfile.Utility.signatureToString(type.getSignature());
                if (s.lastIndexOf(".") != -1) {
                    s = s.substring(s.lastIndexOf(".") + 1);
                }
                parmString.append(s);
                if (i + 1 >= paramTypes.length) continue;
                parmString.append(",");
            }
            parmString.append(")");
            String methodName = member.getName();
            StringBuffer sig = new StringBuffer();
            sig.append(org.aspectj.apache.bcel.classfile.Utility.accessToString(member.getModifiers()));
            sig.append(" ");
            sig.append(member.getReturnType().toString());
            sig.append(" ");
            sig.append(member.getDeclaringType().toString());
            sig.append(".");
            sig.append(methodName.equals("<init>") ? "new" : methodName);
            sig.append(parmString);
            StringBuffer loc = new StringBuffer();
            if (clazz.getFileName() == null) {
                loc.append("no debug info available");
            } else {
                loc.append(clazz.getFileName());
                if (memberLineNumber != -1) {
                    loc.append(":" + memberLineNumber);
                }
            }
            this.getWorld().getMessageHandler().handleMessage(WeaveMessage.constructWeavingMessage(WeaveMessage.WEAVEMESSAGE_ANNOTATES, new String[]{sig.toString(), loc.toString(), decaM.getAnnotationString(), methodName.startsWith("<init>") ? "constructor" : "method", decaM.getAspect().toString(), Utility.beautifyLocation(decaM.getSourceLocation())}));
        }
    }

    private List getMatchingSubset(List declareAnnotations, ResolvedType type) {
        ArrayList<DeclareAnnotation> subset = new ArrayList<DeclareAnnotation>();
        Iterator iter = declareAnnotations.iterator();
        while (iter.hasNext()) {
            DeclareAnnotation da = (DeclareAnnotation)iter.next();
            if (!da.couldEverMatch(type)) continue;
            subset.add(da);
        }
        return subset;
    }

    private List getITDSubset(LazyClassGen clazz, ResolvedTypeMunger.Kind wantedKind) {
        ArrayList<BcelTypeMunger> subset = new ArrayList<BcelTypeMunger>();
        Collection c = clazz.getBcelObjectType().getTypeMungers();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            BcelTypeMunger typeMunger = (BcelTypeMunger)iter.next();
            if (typeMunger.getMunger().getKind() != wantedKind) continue;
            subset.add(typeMunger);
        }
        return subset;
    }

    public LazyMethodGen locateAnnotationHolderForFieldMunger(LazyClassGen clazz, BcelTypeMunger fieldMunger) {
        NewFieldTypeMunger nftm = (NewFieldTypeMunger)fieldMunger.getMunger();
        ResolvedMember lookingFor = AjcMemberMaker.interFieldInitializer(nftm.getSignature(), clazz.getType());
        List meths = clazz.getMethodGens();
        Iterator iter = meths.iterator();
        while (iter.hasNext()) {
            LazyMethodGen element = (LazyMethodGen)iter.next();
            if (!element.getName().equals(lookingFor.getName())) continue;
            return element;
        }
        return null;
    }

    public LazyMethodGen locateAnnotationHolderForMethodCtorMunger(LazyClassGen clazz, BcelTypeMunger methodCtorMunger) {
        if (methodCtorMunger.getMunger() instanceof NewMethodTypeMunger) {
            NewMethodTypeMunger nftm = (NewMethodTypeMunger)methodCtorMunger.getMunger();
            ResolvedMember lookingFor = AjcMemberMaker.interMethodDispatcher(nftm.getSignature(), methodCtorMunger.getAspectType());
            List meths = clazz.getMethodGens();
            Iterator iter = meths.iterator();
            while (iter.hasNext()) {
                LazyMethodGen element = (LazyMethodGen)iter.next();
                if (!element.getName().equals(lookingFor.getName()) || !element.getParameterSignature().equals(lookingFor.getParameterSignature())) continue;
                return element;
            }
            return null;
        }
        if (methodCtorMunger.getMunger() instanceof NewConstructorTypeMunger) {
            NewConstructorTypeMunger nftm = (NewConstructorTypeMunger)methodCtorMunger.getMunger();
            ResolvedMember lookingFor = AjcMemberMaker.postIntroducedConstructor(methodCtorMunger.getAspectType(), nftm.getSignature().getDeclaringType(), nftm.getSignature().getParameterTypes());
            List meths = clazz.getMethodGens();
            Iterator iter = meths.iterator();
            while (iter.hasNext()) {
                LazyMethodGen element = (LazyMethodGen)iter.next();
                if (!element.getName().equals(lookingFor.getName()) || !element.getParameterSignature().equals(lookingFor.getParameterSignature())) continue;
                return element;
            }
            return null;
        }
        throw new RuntimeException("Not sure what this is: " + methodCtorMunger);
    }

    private boolean weaveAtFieldRepeatedly(List decaFs, List itdFields, List reportedErrors) {
        boolean isChanged = false;
        Iterator iter = itdFields.iterator();
        while (iter.hasNext()) {
            BcelTypeMunger fieldMunger = (BcelTypeMunger)iter.next();
            ResolvedMember itdIsActually = fieldMunger.getSignature();
            ArrayList<DeclareAnnotation> worthRetrying = new ArrayList<DeclareAnnotation>();
            boolean modificationOccured = false;
            Iterator iter2 = decaFs.iterator();
            while (iter2.hasNext()) {
                DeclareAnnotation decaF = (DeclareAnnotation)iter2.next();
                if (decaF.matches(itdIsActually, this.world)) {
                    LazyMethodGen annotationHolder = this.locateAnnotationHolderForFieldMunger(this.clazz, fieldMunger);
                    if (this.doesAlreadyHaveAnnotation(annotationHolder, itdIsActually, decaF, reportedErrors)) continue;
                    annotationHolder.addAnnotation(decaF.getAnnotationX());
                    AsmRelationshipProvider.getDefault().addDeclareAnnotationRelationship(decaF.getSourceLocation(), itdIsActually.getSourceLocation());
                    isChanged = true;
                    modificationOccured = true;
                    continue;
                }
                if (decaF.isStarredAnnotationPattern()) continue;
                worthRetrying.add(decaF);
            }
            while (!worthRetrying.isEmpty() && modificationOccured) {
                modificationOccured = false;
                ArrayList<DeclareAnnotation> forRemoval = new ArrayList<DeclareAnnotation>();
                Iterator iter22 = worthRetrying.iterator();
                while (iter.hasNext()) {
                    DeclareAnnotation decaF = (DeclareAnnotation)iter22.next();
                    if (decaF.matches(itdIsActually, this.world)) {
                        LazyMethodGen annotationHolder = this.locateAnnotationHolderForFieldMunger(this.clazz, fieldMunger);
                        if (this.doesAlreadyHaveAnnotation(annotationHolder, itdIsActually, decaF, reportedErrors)) continue;
                        annotationHolder.addAnnotation(decaF.getAnnotationX());
                        AsmRelationshipProvider.getDefault().addDeclareAnnotationRelationship(decaF.getSourceLocation(), itdIsActually.getSourceLocation());
                        isChanged = true;
                        modificationOccured = true;
                        forRemoval.add(decaF);
                    }
                    worthRetrying.removeAll(forRemoval);
                }
            }
        }
        return isChanged;
    }

    private boolean weaveAtMethodOnITDSRepeatedly(List decaMCs, List itdMethodsCtors, List reportedErrors) {
        boolean isChanged = false;
        Iterator iter = itdMethodsCtors.iterator();
        while (iter.hasNext()) {
            BcelTypeMunger methodctorMunger = (BcelTypeMunger)iter.next();
            ResolvedMember unMangledInterMethod = methodctorMunger.getSignature();
            ArrayList<DeclareAnnotation> worthRetrying = new ArrayList<DeclareAnnotation>();
            boolean modificationOccured = false;
            Iterator iter2 = decaMCs.iterator();
            while (iter2.hasNext()) {
                DeclareAnnotation decaMC = (DeclareAnnotation)iter2.next();
                if (decaMC.matches(unMangledInterMethod, this.world)) {
                    LazyMethodGen annotationHolder = this.locateAnnotationHolderForMethodCtorMunger(this.clazz, methodctorMunger);
                    if (annotationHolder == null || this.doesAlreadyHaveAnnotation(annotationHolder, unMangledInterMethod, decaMC, reportedErrors)) continue;
                    annotationHolder.addAnnotation(decaMC.getAnnotationX());
                    isChanged = true;
                    AsmRelationshipProvider.getDefault().addDeclareAnnotationRelationship(decaMC.getSourceLocation(), unMangledInterMethod.getSourceLocation());
                    this.reportMethodCtorWeavingMessage(this.clazz, unMangledInterMethod, decaMC, -1);
                    modificationOccured = true;
                    continue;
                }
                if (decaMC.isStarredAnnotationPattern()) continue;
                worthRetrying.add(decaMC);
            }
            while (!worthRetrying.isEmpty() && modificationOccured) {
                modificationOccured = false;
                ArrayList<DeclareAnnotation> forRemoval = new ArrayList<DeclareAnnotation>();
                Iterator iter22 = worthRetrying.iterator();
                while (iter.hasNext()) {
                    DeclareAnnotation decaMC = (DeclareAnnotation)iter22.next();
                    if (decaMC.matches(unMangledInterMethod, this.world)) {
                        LazyMethodGen annotationHolder = this.locateAnnotationHolderForFieldMunger(this.clazz, methodctorMunger);
                        if (this.doesAlreadyHaveAnnotation(annotationHolder, unMangledInterMethod, decaMC, reportedErrors)) continue;
                        annotationHolder.addAnnotation(decaMC.getAnnotationX());
                        unMangledInterMethod.addAnnotation(decaMC.getAnnotationX());
                        AsmRelationshipProvider.getDefault().addDeclareAnnotationRelationship(decaMC.getSourceLocation(), unMangledInterMethod.getSourceLocation());
                        isChanged = true;
                        modificationOccured = true;
                        forRemoval.add(decaMC);
                    }
                    worthRetrying.removeAll(forRemoval);
                }
            }
        }
        return isChanged;
    }

    private boolean dontAddTwice(DeclareAnnotation decaF, Annotation[] dontAddMeTwice) {
        for (int i = 0; i < dontAddMeTwice.length; ++i) {
            Annotation ann = dontAddMeTwice[i];
            if (ann == null || !decaF.getAnnotationX().getTypeName().equals(ann.getTypeName())) continue;
            return true;
        }
        return false;
    }

    private boolean weaveDeclareAtField(LazyClassGen clazz) {
        List decaFs;
        ArrayList reportedProblems = new ArrayList();
        List allDecafs = this.world.getDeclareAnnotationOnFields();
        if (allDecafs.isEmpty()) {
            return false;
        }
        boolean isChanged = false;
        List itdFields = this.getITDSubset(clazz, ResolvedTypeMunger.Field);
        if (itdFields != null) {
            isChanged = this.weaveAtFieldRepeatedly(allDecafs, itdFields, reportedProblems);
        }
        if ((decaFs = this.getMatchingSubset(allDecafs, clazz.getType())).isEmpty()) {
            return false;
        }
        Field[] fields = clazz.getFieldGens();
        if (fields != null) {
            HashSet unusedDecafs = new HashSet();
            unusedDecafs.addAll(decaFs);
            for (int fieldCounter = 0; fieldCounter < fields.length; ++fieldCounter) {
                BcelField aBcelField = new BcelField(clazz.getBcelObjectType(), fields[fieldCounter]);
                if (aBcelField.getName().startsWith("ajc$")) continue;
                ArrayList<DeclareAnnotation> worthRetrying = new ArrayList<DeclareAnnotation>();
                boolean modificationOccured = false;
                Annotation[] dontAddMeTwice = fields[fieldCounter].getAnnotations();
                Iterator iter = decaFs.iterator();
                while (iter.hasNext()) {
                    DeclareAnnotation decaF = (DeclareAnnotation)iter.next();
                    if (decaF.matches(aBcelField, this.world)) {
                        if (!this.dontAddTwice(decaF, dontAddMeTwice)) {
                            if (this.doesAlreadyHaveAnnotation(aBcelField, decaF, reportedProblems)) {
                                unusedDecafs.remove(decaF);
                                continue;
                            }
                            if (decaF.getAnnotationX().isRuntimeVisible()) {
                                Annotation a = decaF.getAnnotationX().getBcelAnnotation();
                                AnnotationGen ag = new AnnotationGen(a, clazz.getConstantPoolGen(), true);
                                FieldGen myGen = new FieldGen(fields[fieldCounter], clazz.getConstantPoolGen());
                                myGen.addAnnotation(ag);
                                Field newField = myGen.getField();
                                aBcelField.addAnnotation(decaF.getAnnotationX());
                                clazz.replaceField(fields[fieldCounter], newField);
                                fields[fieldCounter] = newField;
                            } else {
                                aBcelField.addAnnotation(decaF.getAnnotationX());
                            }
                        }
                        AsmRelationshipProvider.getDefault().addDeclareAnnotationRelationship(decaF.getSourceLocation(), clazz.getName(), fields[fieldCounter]);
                        this.reportFieldAnnotationWeavingMessage(clazz, fields, fieldCounter, decaF);
                        isChanged = true;
                        modificationOccured = true;
                        unusedDecafs.remove(decaF);
                        continue;
                    }
                    if (decaF.isStarredAnnotationPattern()) continue;
                    worthRetrying.add(decaF);
                }
                while (!worthRetrying.isEmpty() && modificationOccured) {
                    modificationOccured = false;
                    ArrayList<DeclareAnnotation> forRemoval = new ArrayList<DeclareAnnotation>();
                    Iterator iter2 = worthRetrying.iterator();
                    while (iter2.hasNext()) {
                        DeclareAnnotation decaF = (DeclareAnnotation)iter2.next();
                        if (!decaF.matches(aBcelField, this.world)) continue;
                        if (this.doesAlreadyHaveAnnotation(aBcelField, decaF, reportedProblems)) {
                            unusedDecafs.remove(decaF);
                            continue;
                        }
                        aBcelField.addAnnotation(decaF.getAnnotationX());
                        AsmRelationshipProvider.getDefault().addDeclareAnnotationRelationship(decaF.getSourceLocation(), clazz.getName(), fields[fieldCounter]);
                        isChanged = true;
                        modificationOccured = true;
                        forRemoval.add(decaF);
                        unusedDecafs.remove(decaF);
                    }
                    worthRetrying.removeAll(forRemoval);
                }
            }
            this.checkUnusedDeclareAtTypes(unusedDecafs, true);
        }
        return isChanged;
    }

    private void checkUnusedDeclareAtTypes(Set unusedDecaTs, boolean isDeclareAtField) {
        Iterator iter = unusedDecaTs.iterator();
        while (iter.hasNext()) {
            DeclareAnnotation declA = (DeclareAnnotation)iter.next();
            if (!declA.isExactPattern() && !(declA.getSignaturePattern().getDeclaringType() instanceof ExactTypePattern) || declA.getSignaturePattern().getName().isAny() && declA.getKind() != DeclareAnnotation.AT_CONSTRUCTOR) continue;
            boolean itdMatch = false;
            List lst = this.clazz.getType().getInterTypeMungers();
            Iterator iterator = lst.iterator();
            while (iterator.hasNext() && !itdMatch) {
                BcelTypeMunger element = (BcelTypeMunger)iterator.next();
                if (element.getMunger() instanceof NewFieldTypeMunger) {
                    NewFieldTypeMunger nftm = (NewFieldTypeMunger)element.getMunger();
                    itdMatch = declA.getSignaturePattern().matches(nftm.getSignature(), this.world, false);
                    continue;
                }
                if (element.getMunger() instanceof NewMethodTypeMunger) {
                    NewMethodTypeMunger nmtm = (NewMethodTypeMunger)element.getMunger();
                    itdMatch = declA.getSignaturePattern().matches(nmtm.getSignature(), this.world, false);
                    continue;
                }
                if (!(element.getMunger() instanceof NewConstructorTypeMunger)) continue;
                NewConstructorTypeMunger nctm = (NewConstructorTypeMunger)element.getMunger();
                itdMatch = declA.getSignaturePattern().matches(nctm.getSignature(), this.world, false);
            }
            if (itdMatch) continue;
            Message message = null;
            message = isDeclareAtField ? new Message("The field '" + declA.getSignaturePattern().toString() + "' does not exist", declA.getSourceLocation(), true) : new Message("The method '" + declA.getSignaturePattern().toString() + "' does not exist", declA.getSourceLocation(), true);
            this.world.getMessageHandler().handleMessage(message);
        }
    }

    private void reportFieldAnnotationWeavingMessage(LazyClassGen clazz, Field[] fields, int fieldCounter, DeclareAnnotation decaF) {
        if (!this.getWorld().getMessageHandler().isIgnoring(IMessage.WEAVEINFO)) {
            Field theField = fields[fieldCounter];
            this.world.getMessageHandler().handleMessage(WeaveMessage.constructWeavingMessage(WeaveMessage.WEAVEMESSAGE_ANNOTATES, new String[]{theField.toString() + "' of type '" + clazz.getName(), clazz.getFileName(), decaF.getAnnotationString(), "field", decaF.getAspect().toString(), Utility.beautifyLocation(decaF.getSourceLocation())}));
        }
    }

    private boolean doesAlreadyHaveAnnotation(ResolvedMember rm, DeclareAnnotation deca, List reportedProblems) {
        if (rm.hasAnnotation(deca.getAnnotationTypeX())) {
            Integer uniqueID;
            if (this.world.getLint().elementAlreadyAnnotated.isEnabled() && !reportedProblems.contains(uniqueID = new Integer(rm.hashCode() * deca.hashCode()))) {
                reportedProblems.add(uniqueID);
                this.world.getLint().elementAlreadyAnnotated.signal(new String[]{rm.toString(), deca.getAnnotationTypeX().toString()}, rm.getSourceLocation(), new ISourceLocation[]{deca.getSourceLocation()});
            }
            return true;
        }
        return false;
    }

    private boolean doesAlreadyHaveAnnotation(LazyMethodGen rm, ResolvedMember itdfieldsig, DeclareAnnotation deca, List reportedProblems) {
        if (rm != null && rm.hasAnnotation(deca.getAnnotationTypeX())) {
            Integer uniqueID;
            if (this.world.getLint().elementAlreadyAnnotated.isEnabled() && !reportedProblems.contains(uniqueID = new Integer(rm.hashCode() * deca.hashCode()))) {
                reportedProblems.add(uniqueID);
                reportedProblems.add(new Integer(itdfieldsig.hashCode() * deca.hashCode()));
                this.world.getLint().elementAlreadyAnnotated.signal(new String[]{rm.toString(), deca.getAnnotationTypeX().toString()}, rm.getSourceLocation(), new ISourceLocation[]{deca.getSourceLocation()});
            }
            return true;
        }
        return false;
    }

    private Set findAspectsForMungers(LazyMethodGen mg) {
        HashSet<String> aspectsAffectingType = new HashSet<String>();
        Iterator iter = mg.matchedShadows.iterator();
        while (iter.hasNext()) {
            BcelShadow aShadow = (BcelShadow)iter.next();
            Iterator iter2 = aShadow.getMungers().iterator();
            while (iter2.hasNext()) {
                BcelAdvice bAdvice;
                ShadowMunger aMunger = (ShadowMunger)iter2.next();
                if (!(aMunger instanceof BcelAdvice) || (bAdvice = (BcelAdvice)aMunger).getConcreteAspect() == null) continue;
                aspectsAffectingType.add(bAdvice.getConcreteAspect().getName());
            }
        }
        return aspectsAffectingType;
    }

    private boolean inlineSelfConstructors(List methodGens) {
        boolean inlinedSomething = false;
        Iterator i = methodGens.iterator();
        while (i.hasNext()) {
            InstructionHandle ih;
            LazyMethodGen mg = (LazyMethodGen)i.next();
            if (!mg.getName().equals("<init>") || (ih = this.findSuperOrThisCall(mg)) == null || !this.isThisCall(ih)) continue;
            LazyMethodGen donor = this.getCalledMethod(ih);
            BcelClassWeaver.inlineMethod(donor, mg, ih);
            inlinedSomething = true;
        }
        return inlinedSomething;
    }

    private void positionAndImplement(List initializationShadows) {
        Iterator i = initializationShadows.iterator();
        while (i.hasNext()) {
            BcelShadow s = (BcelShadow)i.next();
            this.positionInitializationShadow(s);
            s.implement();
        }
    }

    private void positionInitializationShadow(BcelShadow s) {
        LazyMethodGen mg = s.getEnclosingMethod();
        InstructionHandle call = this.findSuperOrThisCall(mg);
        InstructionList body = mg.getBody();
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(s);
        if (s.getKind() == Shadow.PreInitialization) {
            r.associateWithTargets(Range.genStart(body, body.getStart().getNext()), Range.genEnd(body, call.getPrev()));
        } else {
            r.associateWithTargets(Range.genStart(body, call.getNext()), Range.genEnd(body));
        }
    }

    private boolean isThisCall(InstructionHandle ih) {
        INVOKESPECIAL inst = (INVOKESPECIAL)ih.getInstruction();
        return inst.getClassName(this.cpg).equals(this.clazz.getName());
    }

    public static void inlineMethod(LazyMethodGen donor, LazyMethodGen recipient, InstructionHandle call) {
        InstructionFactory fact = recipient.getEnclosingClass().getFactory();
        IntMap frameEnv = new IntMap();
        InstructionList argumentStores = BcelClassWeaver.genArgumentStores(donor, recipient, frameEnv, fact);
        InstructionList inlineInstructions = BcelClassWeaver.genInlineInstructions(donor, recipient, frameEnv, fact, false);
        inlineInstructions.insert(argumentStores);
        recipient.getBody().append(call, inlineInstructions);
        Utility.deleteInstruction(call, recipient);
    }

    public static void transformSynchronizedMethod(LazyMethodGen synchronizedMethod) {
        InstructionFactory fact = synchronizedMethod.getEnclosingClass().getFactory();
        InstructionList body = synchronizedMethod.getBody();
        InstructionList prepend = new InstructionList();
        Type enclosingClassType = BcelWorld.makeBcelType(synchronizedMethod.getEnclosingClass().getType());
        Type javaLangClassType = Type.getType(class$java$lang$Class == null ? (class$java$lang$Class = BcelClassWeaver.class$("java.lang.Class")) : class$java$lang$Class);
        if (synchronizedMethod.isStatic()) {
            if (synchronizedMethod.getEnclosingClass().isAtLeastJava5()) {
                int slotForLockObject = synchronizedMethod.allocateLocal(enclosingClassType);
                prepend.append(fact.createConstant(enclosingClassType));
                prepend.append(InstructionFactory.createDup(1));
                prepend.append(InstructionFactory.createStore(enclosingClassType, slotForLockObject));
                prepend.append(InstructionConstants.MONITORENTER);
                InstructionList finallyBlock = new InstructionList();
                finallyBlock.append(InstructionFactory.createLoad(Type.getType(class$java$lang$Class == null ? (class$java$lang$Class = BcelClassWeaver.class$("java.lang.Class")) : class$java$lang$Class), slotForLockObject));
                finallyBlock.append(InstructionConstants.MONITOREXIT);
                finallyBlock.append(InstructionConstants.ATHROW);
                ArrayList<InstructionHandle> rets = new ArrayList<InstructionHandle>();
                for (InstructionHandle walker = body.getStart(); walker != null; walker = walker.getNext()) {
                    if (!(walker.getInstruction() instanceof ReturnInstruction)) continue;
                    rets.add(walker);
                }
                if (rets.size() > 0) {
                    Iterator iter = rets.iterator();
                    while (iter.hasNext()) {
                        InstructionHandle element = (InstructionHandle)iter.next();
                        InstructionList monitorExitBlock = new InstructionList();
                        monitorExitBlock.append(InstructionFactory.createLoad(enclosingClassType, slotForLockObject));
                        monitorExitBlock.append(InstructionConstants.MONITOREXIT);
                        InstructionHandle monitorExitBlockStart = body.insert(element, monitorExitBlock);
                        InstructionTargeter[] targeters = element.getTargeters();
                        if (targeters == null) continue;
                        for (int i = 0; i < targeters.length; ++i) {
                            InstructionTargeter targeter = targeters[i];
                            if (targeter instanceof LocalVariableTag || targeter instanceof LineNumberTag) continue;
                            if (targeter instanceof GOTO || targeter instanceof GOTO_W) {
                                targeter.updateTarget(element, monitorExitBlockStart);
                                continue;
                            }
                            if (targeter instanceof BranchInstruction) {
                                targeter.updateTarget(element, monitorExitBlockStart);
                                continue;
                            }
                            throw new RuntimeException("Unexpected targeter encountered during transform: " + targeter);
                        }
                    }
                }
                InstructionHandle finallyStart = finallyBlock.getStart();
                InstructionHandle tryPosition = body.getStart();
                InstructionHandle catchPosition = body.getEnd();
                body.insert(body.getStart(), prepend);
                synchronizedMethod.getBody().append(finallyBlock);
                synchronizedMethod.addExceptionHandler(tryPosition, catchPosition, finallyStart, null, false);
                synchronizedMethod.addExceptionHandler(finallyStart, finallyStart.getNext(), finallyStart, null, false);
            } else {
                Type classType = BcelWorld.makeBcelType(synchronizedMethod.getEnclosingClass().getType());
                Type clazzType = Type.getType(class$java$lang$Class == null ? (class$java$lang$Class = BcelClassWeaver.class$("java.lang.Class")) : class$java$lang$Class);
                InstructionList parttwo = new InstructionList();
                parttwo.append(InstructionFactory.createDup(1));
                int slotForThis = synchronizedMethod.allocateLocal(classType);
                parttwo.append(InstructionFactory.createStore(clazzType, slotForThis));
                parttwo.append(InstructionConstants.MONITORENTER);
                String fieldname = synchronizedMethod.getEnclosingClass().allocateField("class$");
                System.err.println("Going to use field name " + fieldname);
                Field f = new FieldGen(10, Type.getType(class$java$lang$Class == null ? (class$java$lang$Class = BcelClassWeaver.class$("java.lang.Class")) : class$java$lang$Class), fieldname, synchronizedMethod.getEnclosingClass().getConstantPoolGen()).getField();
                synchronizedMethod.getEnclosingClass().addField(f, null);
                prepend.append(fact.createGetStatic("C", fieldname, Type.getType(class$java$lang$Class == null ? (class$java$lang$Class = BcelClassWeaver.class$("java.lang.Class")) : class$java$lang$Class)));
                prepend.append(InstructionFactory.createDup(1));
                prepend.append(InstructionFactory.createBranchInstruction((short)199, parttwo.getStart()));
                prepend.append(InstructionConstants.POP);
                prepend.append(fact.createConstant("C"));
                InstructionHandle tryInstruction = prepend.getEnd();
                prepend.append(fact.createInvoke("java.lang.Class", "forName", clazzType, new Type[]{Type.getType(class$java$lang$String == null ? (class$java$lang$String = BcelClassWeaver.class$("java.lang.String")) : class$java$lang$String)}, (short)184));
                InstructionHandle catchInstruction = prepend.getEnd();
                prepend.append(InstructionFactory.createDup(1));
                prepend.append(fact.createPutStatic(synchronizedMethod.getEnclosingClass().getType().getName(), fieldname, Type.getType(class$java$lang$Class == null ? (class$java$lang$Class = BcelClassWeaver.class$("java.lang.Class")) : class$java$lang$Class)));
                prepend.append(InstructionFactory.createBranchInstruction((short)167, parttwo.getStart()));
                InstructionList catchBlockForLiteralLoadingFail = new InstructionList();
                catchBlockForLiteralLoadingFail.append(fact.createNew((ObjectType)Type.getType(class$java$lang$NoClassDefFoundError == null ? (class$java$lang$NoClassDefFoundError = BcelClassWeaver.class$("java.lang.NoClassDefFoundError")) : class$java$lang$NoClassDefFoundError)));
                catchBlockForLiteralLoadingFail.append(InstructionFactory.createDup_1(1));
                catchBlockForLiteralLoadingFail.append(InstructionConstants.SWAP);
                catchBlockForLiteralLoadingFail.append(fact.createInvoke("java.lang.Throwable", "getMessage", Type.getType(class$java$lang$String == null ? (class$java$lang$String = BcelClassWeaver.class$("java.lang.String")) : class$java$lang$String), new Type[0], (short)182));
                catchBlockForLiteralLoadingFail.append(fact.createInvoke("java.lang.NoClassDefFoundError", "<init>", Type.VOID, new Type[]{Type.getType(class$java$lang$String == null ? (class$java$lang$String = BcelClassWeaver.class$("java.lang.String")) : class$java$lang$String)}, (short)183));
                catchBlockForLiteralLoadingFail.append(InstructionConstants.ATHROW);
                InstructionHandle catchBlockStart = catchBlockForLiteralLoadingFail.getStart();
                prepend.append(catchBlockForLiteralLoadingFail);
                prepend.append(parttwo);
                InstructionList finallyBlock = new InstructionList();
                finallyBlock.append(InstructionFactory.createLoad(Type.getType(class$java$lang$Class == null ? (class$java$lang$Class = BcelClassWeaver.class$("java.lang.Class")) : class$java$lang$Class), slotForThis));
                finallyBlock.append(InstructionConstants.MONITOREXIT);
                finallyBlock.append(InstructionConstants.ATHROW);
                ArrayList<InstructionHandle> rets = new ArrayList<InstructionHandle>();
                for (InstructionHandle walker = body.getStart(); walker != null; walker = walker.getNext()) {
                    if (!(walker.getInstruction() instanceof ReturnInstruction)) continue;
                    rets.add(walker);
                }
                if (rets.size() > 0) {
                    Iterator iter = rets.iterator();
                    while (iter.hasNext()) {
                        InstructionHandle element = (InstructionHandle)iter.next();
                        InstructionList monitorExitBlock = new InstructionList();
                        monitorExitBlock.append(InstructionFactory.createLoad(classType, slotForThis));
                        monitorExitBlock.append(InstructionConstants.MONITOREXIT);
                        InstructionHandle monitorExitBlockStart = body.insert(element, monitorExitBlock);
                        InstructionTargeter[] targeters = element.getTargeters();
                        if (targeters == null) continue;
                        for (int i = 0; i < targeters.length; ++i) {
                            InstructionTargeter targeter = targeters[i];
                            if (targeter instanceof LocalVariableTag || targeter instanceof LineNumberTag) continue;
                            if (targeter instanceof GOTO || targeter instanceof GOTO_W) {
                                targeter.updateTarget(element, monitorExitBlockStart);
                                continue;
                            }
                            if (targeter instanceof BranchInstruction) {
                                targeter.updateTarget(element, monitorExitBlockStart);
                                continue;
                            }
                            throw new RuntimeException("Unexpected targeter encountered during transform: " + targeter);
                        }
                    }
                }
                InstructionHandle finallyStart = finallyBlock.getStart();
                InstructionHandle tryPosition = body.getStart();
                InstructionHandle catchPosition = body.getEnd();
                body.insert(body.getStart(), prepend);
                synchronizedMethod.getBody().append(finallyBlock);
                synchronizedMethod.addExceptionHandler(tryPosition, catchPosition, finallyStart, null, false);
                synchronizedMethod.addExceptionHandler(tryInstruction, catchInstruction, catchBlockStart, (ObjectType)Type.getType(class$java$lang$ClassNotFoundException == null ? (class$java$lang$ClassNotFoundException = BcelClassWeaver.class$("java.lang.ClassNotFoundException")) : class$java$lang$ClassNotFoundException), true);
                synchronizedMethod.addExceptionHandler(finallyStart, finallyStart.getNext(), finallyStart, null, false);
            }
        } else {
            Type classType = BcelWorld.makeBcelType(synchronizedMethod.getEnclosingClass().getType());
            prepend.append(InstructionFactory.createLoad(classType, 0));
            prepend.append(InstructionFactory.createDup(1));
            int slotForThis = synchronizedMethod.allocateLocal(classType);
            prepend.append(InstructionFactory.createStore(classType, slotForThis));
            prepend.append(InstructionConstants.MONITORENTER);
            InstructionList finallyBlock = new InstructionList();
            finallyBlock.append(InstructionFactory.createLoad(classType, slotForThis));
            finallyBlock.append(InstructionConstants.MONITOREXIT);
            finallyBlock.append(InstructionConstants.ATHROW);
            ArrayList<InstructionHandle> rets = new ArrayList<InstructionHandle>();
            for (InstructionHandle walker = body.getStart(); walker != null; walker = walker.getNext()) {
                if (!(walker.getInstruction() instanceof ReturnInstruction)) continue;
                rets.add(walker);
            }
            if (rets.size() > 0) {
                Iterator iter = rets.iterator();
                while (iter.hasNext()) {
                    InstructionHandle element = (InstructionHandle)iter.next();
                    InstructionList monitorExitBlock = new InstructionList();
                    monitorExitBlock.append(InstructionFactory.createLoad(classType, slotForThis));
                    monitorExitBlock.append(InstructionConstants.MONITOREXIT);
                    InstructionHandle monitorExitBlockStart = body.insert(element, monitorExitBlock);
                    InstructionTargeter[] targeters = element.getTargeters();
                    if (targeters == null) continue;
                    for (int i = 0; i < targeters.length; ++i) {
                        InstructionTargeter targeter = targeters[i];
                        if (targeter instanceof LocalVariableTag || targeter instanceof LineNumberTag) continue;
                        if (targeter instanceof GOTO || targeter instanceof GOTO_W) {
                            targeter.updateTarget(element, monitorExitBlockStart);
                            continue;
                        }
                        if (targeter instanceof BranchInstruction) {
                            targeter.updateTarget(element, monitorExitBlockStart);
                            continue;
                        }
                        throw new RuntimeException("Unexpected targeter encountered during transform: " + targeter);
                    }
                }
            }
            InstructionHandle finallyStart = finallyBlock.getStart();
            InstructionHandle tryPosition = body.getStart();
            InstructionHandle catchPosition = body.getEnd();
            body.insert(body.getStart(), prepend);
            synchronizedMethod.getBody().append(finallyBlock);
            synchronizedMethod.addExceptionHandler(tryPosition, catchPosition, finallyStart, null, false);
            synchronizedMethod.addExceptionHandler(finallyStart, finallyStart.getNext(), finallyStart, null, false);
        }
    }

    static InstructionList genInlineInstructions(LazyMethodGen donor, LazyMethodGen recipient, IntMap frameEnv, InstructionFactory fact, boolean keepReturns) {
        InstructionHandle dest;
        ConstantPoolGen recipientCpg;
        InstructionList footer = new InstructionList();
        InstructionHandle end = footer.append(InstructionConstants.NOP);
        InstructionList ret = new InstructionList();
        InstructionList sourceList = donor.getBody();
        HashMap<InstructionHandle, InstructionHandle> srcToDest = new HashMap<InstructionHandle, InstructionHandle>();
        ConstantPoolGen donorCpg = donor.getEnclosingClass().getConstantPoolGen();
        boolean isAcrossClass = donorCpg != (recipientCpg = recipient.getEnclosingClass().getConstantPoolGen());
        for (InstructionHandle src = sourceList.getStart(); src != null; src = src.getNext()) {
            Instruction fresh = Utility.copyInstruction(src.getInstruction());
            if (fresh instanceof CPInstruction && isAcrossClass) {
                CPInstruction cpi = (CPInstruction)fresh;
                cpi.setIndex(recipientCpg.addConstant(donorCpg.getConstant(cpi.getIndex()), donorCpg));
            }
            if (src.getInstruction() == Range.RANGEINSTRUCTION) {
                dest = ret.append(Range.RANGEINSTRUCTION);
            } else if (fresh instanceof ReturnInstruction) {
                dest = keepReturns ? ret.append(fresh) : ret.append(InstructionFactory.createBranchInstruction((short)167, end));
            } else if (fresh instanceof BranchInstruction) {
                dest = ret.append((BranchInstruction)fresh);
            } else if (fresh instanceof LocalVariableInstruction || fresh instanceof RET) {
                int freshIndex;
                IndexedInstruction indexed = (IndexedInstruction)((Object)fresh);
                int oldIndex = indexed.getIndex();
                if (!frameEnv.hasKey(oldIndex)) {
                    freshIndex = recipient.allocateLocal(2);
                    frameEnv.put(oldIndex, freshIndex);
                } else {
                    freshIndex = frameEnv.get(oldIndex);
                }
                indexed.setIndex(freshIndex);
                dest = ret.append(fresh);
            } else {
                dest = ret.append(fresh);
            }
            srcToDest.put(src, dest);
        }
        HashMap<Tag, Tag> tagMap = new HashMap<Tag, Tag>();
        HashMap<ShadowRange, ShadowRange> shadowMap = new HashMap<ShadowRange, ShadowRange>();
        dest = ret.getStart();
        InstructionHandle src = sourceList.getStart();
        while (dest != null) {
            InstructionTargeter[] srcTargeters;
            BranchInstruction branch;
            InstructionHandle oldTarget;
            InstructionHandle newTarget;
            Instruction inst = dest.getInstruction();
            if (inst instanceof BranchInstruction && (newTarget = (InstructionHandle)srcToDest.get(oldTarget = (branch = (BranchInstruction)inst).getTarget())) != null) {
                branch.setTarget(newTarget);
                if (branch instanceof Select) {
                    Select select = (Select)branch;
                    InstructionHandle[] oldTargets = select.getTargets();
                    for (int k = oldTargets.length - 1; k >= 0; --k) {
                        select.setTarget(k, (InstructionHandle)srcToDest.get(oldTargets[k]));
                    }
                }
            }
            if ((srcTargeters = src.getTargeters()) != null) {
                for (int j = srcTargeters.length - 1; j >= 0; --j) {
                    ShadowRange oldRange;
                    InstructionTargeter old = srcTargeters[j];
                    if (old instanceof Tag) {
                        Tag oldTag = (Tag)old;
                        Tag fresh = (Tag)tagMap.get(oldTag);
                        if (fresh == null) {
                            fresh = oldTag.copy();
                            tagMap.put(oldTag, fresh);
                        }
                        dest.addTargeter(fresh);
                        continue;
                    }
                    if (old instanceof ExceptionRange) {
                        ExceptionRange er = (ExceptionRange)old;
                        if (er.getStart() != src) continue;
                        ExceptionRange freshEr = new ExceptionRange(recipient.getBody(), er.getCatchType(), er.getPriority());
                        freshEr.associateWithTargets(dest, (InstructionHandle)srcToDest.get(er.getEnd()), (InstructionHandle)srcToDest.get(er.getHandler()));
                        continue;
                    }
                    if (!(old instanceof ShadowRange) || (oldRange = (ShadowRange)old).getStart() != src) continue;
                    BcelShadow oldShadow = oldRange.getShadow();
                    BcelShadow freshEnclosing = oldShadow.getEnclosingShadow() == null ? null : (BcelShadow)shadowMap.get(oldShadow.getEnclosingShadow());
                    BcelShadow freshShadow = oldShadow.copyInto(recipient, freshEnclosing);
                    ShadowRange freshRange = new ShadowRange(recipient.getBody());
                    freshRange.associateWithShadow(freshShadow);
                    freshRange.associateWithTargets(dest, (InstructionHandle)srcToDest.get(oldRange.getEnd()));
                    shadowMap.put(oldRange, freshRange);
                }
            }
            dest = dest.getNext();
            src = src.getNext();
        }
        if (!keepReturns) {
            ret.append(footer);
        }
        return ret;
    }

    static InstructionList rewriteWithMonitorExitCalls(InstructionList sourceList, InstructionFactory fact, boolean keepReturns, int monitorVarSlot, Type monitorVarType) {
        InstructionHandle dest;
        InstructionList footer = new InstructionList();
        InstructionHandle end = footer.append(InstructionConstants.NOP);
        InstructionList newList = new InstructionList();
        HashMap<InstructionHandle, InstructionHandle> srcToDest = new HashMap<InstructionHandle, InstructionHandle>();
        for (InstructionHandle src = sourceList.getStart(); src != null; src = src.getNext()) {
            Instruction fresh = Utility.copyInstruction(src.getInstruction());
            if (src.getInstruction() == Range.RANGEINSTRUCTION) {
                dest = newList.append(Range.RANGEINSTRUCTION);
            } else if (fresh instanceof ReturnInstruction) {
                if (keepReturns) {
                    newList.append(InstructionFactory.createLoad(monitorVarType, monitorVarSlot));
                    newList.append(InstructionConstants.MONITOREXIT);
                    dest = newList.append(fresh);
                } else {
                    dest = newList.append(InstructionFactory.createBranchInstruction((short)167, end));
                }
            } else if (fresh instanceof BranchInstruction) {
                dest = newList.append((BranchInstruction)fresh);
            } else if (fresh instanceof LocalVariableInstruction || fresh instanceof RET) {
                int oldIndex;
                IndexedInstruction indexed = (IndexedInstruction)((Object)fresh);
                int freshIndex = oldIndex = indexed.getIndex();
                indexed.setIndex(freshIndex);
                dest = newList.append(fresh);
            } else {
                dest = newList.append(fresh);
            }
            srcToDest.put(src, dest);
        }
        HashMap<Tag, Tag> tagMap = new HashMap<Tag, Tag>();
        HashMap shadowMap = new HashMap();
        dest = newList.getStart();
        InstructionHandle src = sourceList.getStart();
        while (dest != null) {
            InstructionTargeter[] srcTargeters;
            BranchInstruction branch;
            InstructionHandle oldTarget;
            InstructionHandle newTarget;
            Instruction inst = dest.getInstruction();
            if (inst instanceof BranchInstruction && (newTarget = (InstructionHandle)srcToDest.get(oldTarget = (branch = (BranchInstruction)inst).getTarget())) != null) {
                branch.setTarget(newTarget);
                if (branch instanceof Select) {
                    Select select = (Select)branch;
                    InstructionHandle[] oldTargets = select.getTargets();
                    for (int k = oldTargets.length - 1; k >= 0; --k) {
                        select.setTarget(k, (InstructionHandle)srcToDest.get(oldTargets[k]));
                    }
                }
            }
            if ((srcTargeters = src.getTargeters()) != null) {
                for (int j = srcTargeters.length - 1; j >= 0; --j) {
                    ExceptionRange er;
                    InstructionTargeter old = srcTargeters[j];
                    if (old instanceof Tag) {
                        Tag oldTag = (Tag)old;
                        Tag fresh = (Tag)tagMap.get(oldTag);
                        if (fresh == null) {
                            fresh = oldTag.copy();
                            tagMap.put(oldTag, fresh);
                        }
                        dest.addTargeter(fresh);
                        continue;
                    }
                    if (!(old instanceof ExceptionRange) || (er = (ExceptionRange)old).getStart() != src) continue;
                    ExceptionRange freshEr = new ExceptionRange(newList, er.getCatchType(), er.getPriority());
                    freshEr.associateWithTargets(dest, (InstructionHandle)srcToDest.get(er.getEnd()), (InstructionHandle)srcToDest.get(er.getHandler()));
                }
            }
            dest = dest.getNext();
            src = src.getNext();
        }
        if (!keepReturns) {
            newList.append(footer);
        }
        return newList;
    }

    private static InstructionList genArgumentStores(LazyMethodGen donor, LazyMethodGen recipient, IntMap frameEnv, InstructionFactory fact) {
        InstructionList ret = new InstructionList();
        int donorFramePos = 0;
        if (!donor.isStatic()) {
            int targetSlot = recipient.allocateLocal(Type.OBJECT);
            ret.insert(InstructionFactory.createStore(Type.OBJECT, targetSlot));
            frameEnv.put(donorFramePos, targetSlot);
            ++donorFramePos;
        }
        Type[] argTypes = donor.getArgumentTypes();
        int len = argTypes.length;
        for (int i = 0; i < len; ++i) {
            Type argType = argTypes[i];
            int argSlot = recipient.allocateLocal(argType);
            ret.insert(InstructionFactory.createStore(argType, argSlot));
            frameEnv.put(donorFramePos, argSlot);
            donorFramePos += argType.getSize();
        }
        return ret;
    }

    private LazyMethodGen getCalledMethod(InstructionHandle ih) {
        InvokeInstruction inst = (InvokeInstruction)ih.getInstruction();
        String methodName = inst.getName(this.cpg);
        String signature = inst.getSignature(this.cpg);
        return this.clazz.getLazyMethodGen(methodName, signature);
    }

    private void weaveInAddedMethods() {
        Collections.sort(this.addedLazyMethodGens, new Comparator(){

            public int compare(Object a, Object b) {
                LazyMethodGen aa = (LazyMethodGen)a;
                LazyMethodGen bb = (LazyMethodGen)b;
                int i = aa.getName().compareTo(bb.getName());
                if (i != 0) {
                    return i;
                }
                return aa.getSignature().compareTo(bb.getSignature());
            }
        });
        Iterator i = this.addedLazyMethodGens.iterator();
        while (i.hasNext()) {
            this.clazz.addMethodGen((LazyMethodGen)i.next());
        }
    }

    void addPerSingletonField(Member field) {
        ObjectType aspectType = (ObjectType)BcelWorld.makeBcelType(field.getReturnType());
        String aspectName = field.getReturnType().getName();
        LazyMethodGen clinit = this.clazz.getStaticInitializer();
        InstructionList setup = new InstructionList();
        InstructionFactory fact = this.clazz.getFactory();
        setup.append(fact.createNew(aspectType));
        setup.append(InstructionFactory.createDup(1));
        setup.append(fact.createInvoke(aspectName, "<init>", Type.VOID, new Type[0], (short)183));
        setup.append(fact.createFieldAccess(aspectName, field.getName(), aspectType, (short)179));
        clinit.getBody().insert(setup);
    }

    private InstructionHandle findSuperOrThisCall(LazyMethodGen mg) {
        int depth = 1;
        InstructionHandle start = mg.getBody().getStart();
        while (start != null) {
            Instruction inst = start.getInstruction();
            if (inst instanceof INVOKESPECIAL && ((INVOKESPECIAL)inst).getName(this.cpg).equals("<init>")) {
                if (--depth == 0) {
                    return start;
                }
            } else if (inst instanceof NEW) {
                ++depth;
            }
            start = start.getNext();
        }
        return null;
    }

    private boolean match(LazyMethodGen mg) {
        BcelShadow enclosingShadow;
        boolean startsAngly;
        ArrayList shadowAccumulator = new ArrayList();
        boolean bl = startsAngly = mg.getName().charAt(0) == '<';
        if (startsAngly && mg.getName().equals("<init>")) {
            return this.matchInit(mg, shadowAccumulator);
        }
        if (!this.shouldWeaveBody(mg)) {
            return false;
        }
        if (startsAngly && mg.getName().equals("<clinit>")) {
            this.clinitShadow = enclosingShadow = BcelShadow.makeStaticInitialization(this.world, mg);
        } else if (mg.isAdviceMethod()) {
            enclosingShadow = BcelShadow.makeAdviceExecution(this.world, mg);
        } else {
            AjAttribute.EffectiveSignatureAttribute effective = mg.getEffectiveSignature();
            if (effective == null) {
                enclosingShadow = BcelShadow.makeMethodExecution(this.world, mg, !this.canMatchBodyShadows);
            } else if (effective.isWeaveBody()) {
                ResolvedMember rm = effective.getEffectiveSignature();
                this.fixAnnotationsForResolvedMember(rm, mg.getMemberView());
                enclosingShadow = BcelShadow.makeShadowForMethod(this.world, mg, effective.getShadowKind(), rm);
            } else {
                return false;
            }
        }
        if (this.canMatchBodyShadows) {
            for (InstructionHandle h = mg.getBody().getStart(); h != null; h = h.getNext()) {
                this.match(mg, h, enclosingShadow, shadowAccumulator);
            }
        }
        if (this.canMatch(enclosingShadow.getKind()) && (mg.getName().charAt(0) != 'a' || !mg.getName().startsWith("ajc$interFieldInit")) && this.match(enclosingShadow, shadowAccumulator)) {
            enclosingShadow.init();
        }
        mg.matchedShadows = shadowAccumulator;
        return !shadowAccumulator.isEmpty();
    }

    private boolean matchInit(LazyMethodGen mg, List shadowAccumulator) {
        InstructionHandle superOrThisCall = this.findSuperOrThisCall(mg);
        if (superOrThisCall == null) {
            return false;
        }
        BcelShadow enclosingShadow = BcelShadow.makeConstructorExecution(this.world, mg, superOrThisCall);
        if (mg.getEffectiveSignature() != null) {
            enclosingShadow.setMatchingSignature(mg.getEffectiveSignature().getEffectiveSignature());
        }
        boolean beforeSuperOrThisCall = true;
        if (this.shouldWeaveBody(mg)) {
            if (this.canMatchBodyShadows) {
                for (InstructionHandle h = mg.getBody().getStart(); h != null; h = h.getNext()) {
                    if (h == superOrThisCall) {
                        beforeSuperOrThisCall = false;
                        continue;
                    }
                    this.match(mg, h, beforeSuperOrThisCall ? null : enclosingShadow, shadowAccumulator);
                }
            }
            if (this.canMatch(Shadow.ConstructorExecution)) {
                this.match(enclosingShadow, shadowAccumulator);
            }
        }
        if (superOrThisCall != null && !this.isThisCall(superOrThisCall)) {
            InstructionHandle curr = enclosingShadow.getRange().getStart();
            Iterator i = this.addedSuperInitializersAsList.iterator();
            while (i.hasNext()) {
                IfaceInitList l = (IfaceInitList)i.next();
                Member ifaceInitSig = AjcMemberMaker.interfaceConstructor(l.onType);
                BcelShadow initShadow = BcelShadow.makeIfaceInitialization(this.world, mg, ifaceInitSig);
                InstructionList inits = this.genInitInstructions(l.list, false);
                if (!this.match(initShadow, shadowAccumulator) && inits.isEmpty()) continue;
                initShadow.initIfaceInitializer(curr);
                initShadow.getRange().insert(inits, Range.OutsideBefore);
            }
            InstructionList inits = this.genInitInstructions(this.addedThisInitializers, false);
            enclosingShadow.getRange().insert(inits, Range.OutsideBefore);
        }
        boolean addedInitialization = this.match(BcelShadow.makeUnfinishedInitialization(this.world, mg), this.initializationShadows);
        mg.matchedShadows = shadowAccumulator;
        return (addedInitialization |= this.match(BcelShadow.makeUnfinishedPreinitialization(this.world, mg), this.initializationShadows)) || !shadowAccumulator.isEmpty();
    }

    private boolean shouldWeaveBody(LazyMethodGen mg) {
        if (mg.isBridgeMethod()) {
            return false;
        }
        if (mg.isAjSynthetic()) {
            return mg.getName().equals("<clinit>");
        }
        AjAttribute.EffectiveSignatureAttribute a = mg.getEffectiveSignature();
        if (a != null) {
            return a.isWeaveBody();
        }
        return true;
    }

    private InstructionList genInitInstructions(List list, boolean isStatic) {
        if ((list = PartialOrder.sort(list)) == null) {
            throw new BCException("circularity in inter-types");
        }
        InstructionList ret = new InstructionList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger cmunger = (ConcreteTypeMunger)i.next();
            NewFieldTypeMunger munger = (NewFieldTypeMunger)cmunger.getMunger();
            ResolvedMember initMethod = munger.getInitMethod(cmunger.getAspectType());
            if (!isStatic) {
                ret.append(InstructionConstants.ALOAD_0);
            }
            ret.append(Utility.createInvoke(this.fact, this.world, (Member)initMethod));
        }
        return ret;
    }

    private void match(LazyMethodGen mg, InstructionHandle ih, BcelShadow enclosingShadow, List shadowAccumulator) {
        Instruction i = ih.getInstruction();
        if (i instanceof FieldInstruction && (this.canMatch(Shadow.FieldGet) || this.canMatch(Shadow.FieldSet))) {
            FieldInstruction fi = (FieldInstruction)i;
            if (fi instanceof PUTFIELD || fi instanceof PUTSTATIC) {
                InstructionHandle prevHandle = ih.getPrev();
                Instruction prevI = prevHandle.getInstruction();
                if (Utility.isConstantPushInstruction(prevI)) {
                    Member field = BcelWorld.makeFieldJoinPointSignature(this.clazz, (FieldInstruction)i);
                    ResolvedMember resolvedField = field.resolve(this.world);
                    if (resolvedField != null && !Modifier.isFinal(resolvedField.getModifiers()) && this.canMatch(Shadow.FieldSet)) {
                        this.matchSetInstruction(mg, ih, enclosingShadow, shadowAccumulator);
                    }
                } else if (this.canMatch(Shadow.FieldSet)) {
                    this.matchSetInstruction(mg, ih, enclosingShadow, shadowAccumulator);
                }
            } else if (this.canMatch(Shadow.FieldGet)) {
                this.matchGetInstruction(mg, ih, enclosingShadow, shadowAccumulator);
            }
        } else if (i instanceof InvokeInstruction) {
            InvokeInstruction ii = (InvokeInstruction)i;
            if (ii.getMethodName(this.clazz.getConstantPoolGen()).equals("<init>")) {
                if (this.canMatch(Shadow.ConstructorCall)) {
                    this.match(BcelShadow.makeConstructorCall(this.world, mg, ih, enclosingShadow), shadowAccumulator);
                }
            } else if (ii instanceof INVOKESPECIAL) {
                String onTypeName = ii.getClassName(this.cpg);
                if (onTypeName.equals(mg.getEnclosingClass().getName())) {
                    this.matchInvokeInstruction(mg, ih, ii, enclosingShadow, shadowAccumulator);
                }
            } else {
                this.matchInvokeInstruction(mg, ih, ii, enclosingShadow, shadowAccumulator);
            }
        } else if (this.world.isJoinpointArrayConstructionEnabled() && (i instanceof NEWARRAY || i instanceof ANEWARRAY || i instanceof MULTIANEWARRAY)) {
            if (this.canMatch(Shadow.ConstructorCall)) {
                BcelShadow ctorCallShadow;
                Type arrayType;
                Instruction arrayInstruction;
                boolean debug = false;
                if (debug) {
                    System.err.println("Found new array instruction: " + i);
                }
                if (i instanceof ANEWARRAY) {
                    arrayInstruction = (ANEWARRAY)i;
                    arrayType = ((ANEWARRAY)arrayInstruction).getLoadClassType(this.clazz.getConstantPoolGen());
                    if (debug) {
                        System.err.println("Array type is " + arrayType);
                    }
                    ctorCallShadow = BcelShadow.makeArrayConstructorCall(this.world, mg, ih, enclosingShadow);
                    this.match(ctorCallShadow, shadowAccumulator);
                } else if (i instanceof NEWARRAY) {
                    arrayInstruction = (NEWARRAY)i;
                    arrayType = ((NEWARRAY)arrayInstruction).getType();
                    if (debug) {
                        System.err.println("Array type is " + arrayType);
                    }
                    ctorCallShadow = BcelShadow.makeArrayConstructorCall(this.world, mg, ih, enclosingShadow);
                    this.match(ctorCallShadow, shadowAccumulator);
                } else if (i instanceof MULTIANEWARRAY) {
                    arrayInstruction = (MULTIANEWARRAY)i;
                    arrayType = ((MULTIANEWARRAY)arrayInstruction).getLoadClassType(this.clazz.getConstantPoolGen());
                    if (debug) {
                        System.err.println("Array type is " + arrayType);
                    }
                    ctorCallShadow = BcelShadow.makeArrayConstructorCall(this.world, mg, ih, enclosingShadow);
                    this.match(ctorCallShadow, shadowAccumulator);
                }
            }
        } else if (this.world.isJoinpointSynchronizationEnabled() && (i instanceof MONITORENTER || i instanceof MONITOREXIT)) {
            if (i instanceof MONITORENTER) {
                BcelShadow monitorEntryShadow = BcelShadow.makeMonitorEnter(this.world, mg, ih, enclosingShadow);
                this.match(monitorEntryShadow, shadowAccumulator);
            } else {
                BcelShadow monitorExitShadow = BcelShadow.makeMonitorExit(this.world, mg, ih, enclosingShadow);
                this.match(monitorExitShadow, shadowAccumulator);
            }
        }
        if (!this.canMatch(Shadow.ExceptionHandler)) {
            return;
        }
        if (Range.isRangeHandle(ih)) {
            return;
        }
        InstructionTargeter[] targeters = ih.getTargeters();
        if (targeters != null) {
            for (int j = 0; j < targeters.length; ++j) {
                ExceptionRange er;
                InstructionTargeter t = targeters[j];
                if (!(t instanceof ExceptionRange) || (er = (ExceptionRange)t).getCatchType() == null) continue;
                if (this.isInitFailureHandler(ih)) {
                    return;
                }
                this.match(BcelShadow.makeExceptionHandler(this.world, er, mg, ih, enclosingShadow), shadowAccumulator);
            }
        }
    }

    private boolean isInitFailureHandler(InstructionHandle ih) {
        String name;
        InstructionHandle twoInstructionsAway = ih.getNext().getNext();
        return twoInstructionsAway.getInstruction() instanceof PUTSTATIC && (name = ((PUTSTATIC)twoInstructionsAway.getInstruction()).getFieldName(this.cpg)).equals("ajc$initFailureCause");
    }

    private void matchSetInstruction(LazyMethodGen mg, InstructionHandle ih, BcelShadow enclosingShadow, List shadowAccumulator) {
        FieldInstruction fi = (FieldInstruction)ih.getInstruction();
        Member field = BcelWorld.makeFieldJoinPointSignature(this.clazz, fi);
        if (field.getName().startsWith("ajc$")) {
            return;
        }
        ResolvedMember resolvedField = field.resolve(this.world);
        if (resolvedField == null) {
            return;
        }
        if (Modifier.isFinal(resolvedField.getModifiers()) && Utility.isConstantPushInstruction(ih.getPrev().getInstruction())) {
            return;
        }
        if (resolvedField.isSynthetic()) {
            return;
        }
        this.match(BcelShadow.makeFieldSet(this.world, mg, ih, enclosingShadow), shadowAccumulator);
    }

    private void matchGetInstruction(LazyMethodGen mg, InstructionHandle ih, BcelShadow enclosingShadow, List shadowAccumulator) {
        FieldInstruction fi = (FieldInstruction)ih.getInstruction();
        Member field = BcelWorld.makeFieldJoinPointSignature(this.clazz, fi);
        if (field.getName().startsWith("ajc$")) {
            return;
        }
        ResolvedMember resolvedField = field.resolve(this.world);
        if (resolvedField == null) {
            return;
        }
        if (resolvedField.isSynthetic()) {
            return;
        }
        BcelShadow bs = BcelShadow.makeFieldGet(this.world, resolvedField, mg, ih, enclosingShadow);
        String cname = fi.getClassName(this.cpg);
        if (!resolvedField.getDeclaringType().getName().equals(cname)) {
            bs.setActualTargetType(cname);
        }
        this.match(bs, shadowAccumulator);
    }

    private ResolvedMember findResolvedMemberNamed(ResolvedType type, String methodName) {
        ResolvedMember[] allMethods = type.getDeclaredMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            ResolvedMember member = allMethods[i];
            if (!member.getName().equals(methodName)) continue;
            return member;
        }
        return null;
    }

    private void fixAnnotationsForResolvedMember(ResolvedMember rm, ResolvedMember declaredSig) {
        try {
            UnresolvedType memberHostType = declaredSig.getDeclaringType();
            UnresolvedType[] annotations = (ResolvedType[])this.mapToAnnotations.get(rm);
            String methodName = declaredSig.getName();
            if (annotations == null) {
                if (rm.getKind() == Member.FIELD) {
                    if (methodName.startsWith("ajc$inlineAccessField")) {
                        ResolvedMember resolvedDooberry = this.world.resolve(rm);
                        annotations = resolvedDooberry.getAnnotationTypes();
                    } else {
                        ResolvedMember realthing = AjcMemberMaker.interFieldInitializer(rm, memberHostType);
                        ResolvedMember resolvedDooberry = this.world.resolve(realthing);
                        annotations = resolvedDooberry.getAnnotationTypes();
                    }
                } else if (rm.getKind() == Member.METHOD && !rm.isAbstract()) {
                    if (methodName.startsWith("ajc$inlineAccessMethod") || methodName.startsWith("ajc$superDispatch")) {
                        ResolvedMember resolvedDooberry = this.world.resolve(declaredSig);
                        annotations = resolvedDooberry.getAnnotationTypes();
                    } else {
                        ResolvedMember realthing = AjcMemberMaker.interMethodDispatcher(rm.resolve(this.world), memberHostType).resolve(this.world);
                        ResolvedMember theRealMember = this.findResolvedMemberNamed(memberHostType.resolve(this.world), realthing.getName());
                        if (theRealMember == null) {
                            throw new UnsupportedOperationException("Known limitation in M4 - can't find ITD members when type variable is used as an argument and has upper bound specified");
                        }
                        annotations = theRealMember.getAnnotationTypes();
                    }
                } else if (rm.getKind() == Member.CONSTRUCTOR) {
                    ResolvedMember realThing = AjcMemberMaker.postIntroducedConstructor(memberHostType.resolve(this.world), rm.getDeclaringType(), rm.getParameterTypes());
                    ResolvedMember resolvedDooberry = this.world.resolve(realThing);
                    if (resolvedDooberry == null) {
                        throw new UnsupportedOperationException("Known limitation in M4 - can't find ITD members when type variable is used as an argument and has upper bound specified");
                    }
                    annotations = resolvedDooberry.getAnnotationTypes();
                }
                if (annotations == null) {
                    annotations = new ResolvedType[]{};
                }
                this.mapToAnnotations.put(rm, annotations);
            }
            rm.setAnnotationTypes(annotations);
        }
        catch (UnsupportedOperationException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new BCException("Unexpectedly went bang when searching for annotations on " + rm, t);
        }
    }

    private void matchInvokeInstruction(LazyMethodGen mg, InstructionHandle ih, InvokeInstruction invoke, BcelShadow enclosingShadow, List shadowAccumulator) {
        String methodName = invoke.getName(this.cpg);
        if (methodName.startsWith("ajc$")) {
            Member jpSig = this.world.makeJoinPointSignatureForMethodInvocation(this.clazz, invoke);
            ResolvedMember declaredSig = jpSig.resolve(this.world);
            if (declaredSig == null) {
                return;
            }
            if (declaredSig.getKind() == Member.FIELD) {
                Shadow.Kind kind = jpSig.getReturnType().equals(ResolvedType.VOID) ? Shadow.FieldSet : Shadow.FieldGet;
                if (this.canMatch(Shadow.FieldGet) || this.canMatch(Shadow.FieldSet)) {
                    this.match(BcelShadow.makeShadowForMethodCall(this.world, mg, ih, enclosingShadow, kind, declaredSig), shadowAccumulator);
                }
            } else {
                AjAttribute.EffectiveSignatureAttribute effectiveSig = declaredSig.getEffectiveSignature();
                if (effectiveSig == null) {
                    return;
                }
                if (effectiveSig.isWeaveBody()) {
                    return;
                }
                ResolvedMember rm = effectiveSig.getEffectiveSignature();
                this.fixAnnotationsForResolvedMember(rm, declaredSig);
                if (this.canMatch(effectiveSig.getShadowKind())) {
                    this.match(BcelShadow.makeShadowForMethodCall(this.world, mg, ih, enclosingShadow, effectiveSig.getShadowKind(), rm), shadowAccumulator);
                }
            }
        } else if (this.canMatch(Shadow.MethodCall)) {
            this.match(BcelShadow.makeMethodCall(this.world, mg, ih, enclosingShadow), shadowAccumulator);
        }
    }

    private boolean match(BcelShadow shadow, List shadowAccumulator) {
        if (captureLowLevelContext) {
            ContextToken shadowMatchToken = CompilationAndWeavingContext.enteringPhase(28, shadow);
            boolean isMatched = false;
            Iterator i = this.shadowMungers.iterator();
            while (i.hasNext()) {
                ShadowMunger munger = (ShadowMunger)i.next();
                ContextToken mungerMatchToken = CompilationAndWeavingContext.enteringPhase(30, munger.getPointcut());
                if (munger.match(shadow, this.world)) {
                    WeaverMetrics.recordMatchResult(true);
                    shadow.addMunger(munger);
                    isMatched = true;
                    if (shadow.getKind() == Shadow.StaticInitialization) {
                        this.clazz.warnOnAddedStaticInitializer(shadow, munger.getSourceLocation());
                    }
                } else {
                    WeaverMetrics.recordMatchResult(false);
                }
                CompilationAndWeavingContext.leavingPhase(mungerMatchToken);
            }
            if (isMatched) {
                shadowAccumulator.add(shadow);
            }
            CompilationAndWeavingContext.leavingPhase(shadowMatchToken);
            return isMatched;
        }
        boolean isMatched = false;
        Iterator i = this.shadowMungers.iterator();
        while (i.hasNext()) {
            ShadowMunger munger = (ShadowMunger)i.next();
            if (!munger.match(shadow, this.world)) continue;
            shadow.addMunger(munger);
            isMatched = true;
            if (shadow.getKind() != Shadow.StaticInitialization) continue;
            this.clazz.warnOnAddedStaticInitializer(shadow, munger.getSourceLocation());
        }
        if (isMatched) {
            shadowAccumulator.add(shadow);
        }
        return isMatched;
    }

    private void implement(LazyMethodGen mg) {
        List shadows = mg.matchedShadows;
        if (shadows == null) {
            return;
        }
        Iterator i = shadows.iterator();
        while (i.hasNext()) {
            BcelShadow shadow = (BcelShadow)i.next();
            ContextToken tok = CompilationAndWeavingContext.enteringPhase(29, shadow);
            shadow.implement();
            CompilationAndWeavingContext.leavingPhase(tok);
        }
        int ii = mg.getMaxLocals();
        mg.matchedShadows = null;
    }

    public LazyClassGen getLazyClassGen() {
        return this.clazz;
    }

    public List getShadowMungers() {
        return this.shadowMungers;
    }

    public BcelWorld getWorld() {
        return this.world;
    }

    public static void setReweavableMode(boolean mode) {
        inReweavableMode = mode;
    }

    public static boolean getReweavableMode() {
        return inReweavableMode;
    }

    public String toString() {
        return "BcelClassWeaver instance for : " + this.clazz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class IfaceInitList
    implements PartialOrder.PartialComparable {
        final ResolvedType onType;
        List list = new ArrayList();

        IfaceInitList(ResolvedType onType) {
            this.onType = onType;
        }

        public int compareTo(Object other) {
            IfaceInitList o = (IfaceInitList)other;
            if (this.onType.isAssignableFrom(o.onType)) {
                return 1;
            }
            if (o.onType.isAssignableFrom(this.onType)) {
                return -1;
            }
            return 0;
        }

        public int fallbackCompareTo(Object other) {
            return 0;
        }
    }
}

