/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.asm;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.org.objectweb.asm.AnnotationVisitor;
import org.aspectj.org.objectweb.asm.Type;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationAnnotationValue;
import org.aspectj.weaver.AnnotationValue;
import org.aspectj.weaver.ArrayAnnotationValue;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ClassAnnotationValue;
import org.aspectj.weaver.EnumAnnotationValue;
import org.aspectj.weaver.SimpleAnnotationValue;
import org.aspectj.weaver.asm.AnnVisitor;

class ArrayAnnotationVisitor
implements AnnotationVisitor {
    List arrayValues = new ArrayList();
    boolean vis;
    ArrayAnnotationValue val;

    public ArrayAnnotationVisitor(ArrayAnnotationValue val, boolean visibility) {
        this.val = val;
        this.vis = visibility;
    }

    public void visit(String name, Object value) {
        AnnotationValue val = null;
        if (value instanceof Integer) {
            val = new SimpleAnnotationValue(73, value);
        }
        if (value instanceof Boolean) {
            val = new SimpleAnnotationValue(90, value);
        }
        if (value instanceof String) {
            val = new SimpleAnnotationValue(115, value);
        }
        if (value instanceof Long) {
            val = new SimpleAnnotationValue(74, value);
        }
        if (value instanceof Short) {
            val = new SimpleAnnotationValue(83, value);
        }
        if (value instanceof Double) {
            val = new SimpleAnnotationValue(68, value);
        }
        if (value instanceof Float) {
            val = new SimpleAnnotationValue(70, value);
        }
        if (value instanceof Character) {
            val = new SimpleAnnotationValue(67, value);
        }
        if (value instanceof Byte) {
            val = new SimpleAnnotationValue(66, value);
        }
        if (val == null && value instanceof Type) {
            String classSignature = ((Type)value).getDescriptor();
            val = new ClassAnnotationValue(classSignature);
        }
        if (val == null) {
            throw new BCException("ArrayAnnotationVisitor choking on " + name + " = " + value);
        }
        this.arrayValues.add(val);
    }

    public void visitEnum(String name, String type, String value) {
        EnumAnnotationValue val = new EnumAnnotationValue(type, value);
        this.arrayValues.add(val);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        AnnotationAJ annotation = new AnnotationAJ(desc, this.vis);
        AnnotationAnnotationValue val = new AnnotationAnnotationValue(annotation);
        this.arrayValues.add(val);
        return new AnnVisitor(annotation);
    }

    public AnnotationVisitor visitArray(String arg0) {
        ArrayAnnotationValue val = new ArrayAnnotationValue();
        this.arrayValues.add(val);
        return new ArrayAnnotationVisitor(val, this.vis);
    }

    public void visitEnd() {
        this.val.setValues(this.arrayValues.toArray(new AnnotationValue[0]));
    }
}

