/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.UnresolvedTypeVariableReferenceType;
import org.aspectj.weaver.World;

public class TypeFactory {
    public static ReferenceType createParameterizedType(ResolvedType aBaseType, UnresolvedType[] someTypeParameters, World inAWorld) {
        ResolvedType baseType = aBaseType;
        if (!aBaseType.isGenericType() && someTypeParameters != null && someTypeParameters.length > 0) {
            if (!aBaseType.isRawType()) {
                throw new IllegalStateException("Expecting raw type");
            }
            if ((baseType = baseType.getGenericType()) == null) {
                throw new IllegalStateException("Raw type does not have generic type set");
            }
        }
        ResolvedType[] resolvedParameters = inAWorld.resolve(someTypeParameters);
        ReferenceType pType = new ReferenceType(baseType, resolvedParameters, inAWorld);
        return (ReferenceType)pType.resolve(inAWorld);
    }

    public static UnresolvedType createUnresolvedParameterizedType(String sig, String erasuresig, UnresolvedType[] arguments) {
        return new UnresolvedType(sig, erasuresig, arguments);
    }

    public static ReferenceType createRawType(ResolvedType aBaseType, World inAWorld) {
        if (aBaseType.isRawType()) {
            return (ReferenceType)aBaseType;
        }
        if (!aBaseType.isGenericType() && !aBaseType.isRawType()) {
            throw new IllegalStateException("Expecting generic type");
        }
        ReferenceType rType = new ReferenceType(aBaseType, inAWorld);
        return (ReferenceType)rType.resolve(inAWorld);
    }

    private static UnresolvedType convertSigToType(String aSignature) {
        UnresolvedType bound = null;
        int startOfParams = aSignature.indexOf(60);
        if (startOfParams == -1) {
            bound = UnresolvedType.forSignature(aSignature);
        } else {
            int endOfParams = aSignature.lastIndexOf(62);
            String signatureErasure = "L" + aSignature.substring(1, startOfParams) + ";";
            UnresolvedType[] typeParams = TypeFactory.createTypeParams(aSignature.substring(startOfParams + 1, endOfParams));
            bound = new UnresolvedType("P" + aSignature.substring(1), signatureErasure, typeParams);
        }
        return bound;
    }

    public static UnresolvedType createTypeFromSignature(String signature) {
        if (signature.equals("@missing@")) {
            return ResolvedType.MISSING;
        }
        char firstChar = signature.charAt(0);
        if (firstChar == 'P') {
            int startOfParams = signature.indexOf(60);
            int endOfParams = signature.lastIndexOf(62);
            if (startOfParams == -1) {
                String signatureErasure = "L" + signature.substring(1);
                UnresolvedType[] typeParams = new UnresolvedType[]{};
                return new UnresolvedType(signature, signatureErasure, typeParams);
            }
            String signatureErasure = "L" + signature.substring(1, startOfParams) + ";";
            UnresolvedType[] typeParams = TypeFactory.createTypeParams(signature.substring(startOfParams + 1, endOfParams));
            return new UnresolvedType(signature, signatureErasure, typeParams);
        }
        if (signature.equals("?")) {
            UnresolvedType ret = UnresolvedType.SOMETHING;
            ret.typeKind = UnresolvedType.TypeKind.WILDCARD;
            return ret;
        }
        if (firstChar == '+') {
            UnresolvedType ret = new UnresolvedType(signature);
            ret.typeKind = UnresolvedType.TypeKind.WILDCARD;
            ret.setUpperBound(TypeFactory.convertSigToType(signature.substring(1)));
            return ret;
        }
        if (firstChar == '-') {
            UnresolvedType ret = new UnresolvedType(signature);
            ret.typeKind = UnresolvedType.TypeKind.WILDCARD;
            ret.setLowerBound(TypeFactory.convertSigToType(signature.substring(1)));
            return ret;
        }
        if (firstChar == 'T') {
            String typeVariableName = signature.substring(1);
            if (typeVariableName.endsWith(";")) {
                typeVariableName = typeVariableName.substring(0, typeVariableName.length() - 1);
            }
            return new UnresolvedTypeVariableReferenceType(new TypeVariable(typeVariableName));
        }
        if (firstChar == '[') {
            int dims = 0;
            while (signature.charAt(dims) == '[') {
                ++dims;
            }
            UnresolvedType componentType = TypeFactory.createTypeFromSignature(signature.substring(dims));
            return new UnresolvedType(signature, signature.substring(0, dims) + componentType.getErasureSignature());
        }
        if (signature.length() == 1) {
            switch (firstChar) {
                case 'V': {
                    return ResolvedType.VOID;
                }
                case 'Z': {
                    return ResolvedType.BOOLEAN;
                }
                case 'B': {
                    return ResolvedType.BYTE;
                }
                case 'C': {
                    return ResolvedType.CHAR;
                }
                case 'D': {
                    return ResolvedType.DOUBLE;
                }
                case 'F': {
                    return ResolvedType.FLOAT;
                }
                case 'I': {
                    return ResolvedType.INT;
                }
                case 'J': {
                    return ResolvedType.LONG;
                }
                case 'S': {
                    return ResolvedType.SHORT;
                }
            }
        }
        return new UnresolvedType(signature);
    }

    private static UnresolvedType[] createTypeParams(String typeParameterSpecification) {
        String remainingToProcess = typeParameterSpecification;
        ArrayList<UnresolvedType> types = new ArrayList<UnresolvedType>();
        while (!remainingToProcess.equals("")) {
            int endOfSig = 0;
            int anglies = 0;
            boolean sigFound = false;
            block6: for (endOfSig = 0; endOfSig < remainingToProcess.length() && !sigFound; ++endOfSig) {
                char thisChar = remainingToProcess.charAt(endOfSig);
                switch (thisChar) {
                    case '<': {
                        ++anglies;
                        continue block6;
                    }
                    case '>': {
                        --anglies;
                        continue block6;
                    }
                    case ';': {
                        if (anglies != 0) continue block6;
                        sigFound = true;
                    }
                }
            }
            types.add(TypeFactory.createTypeFromSignature(remainingToProcess.substring(0, endOfSig)));
            remainingToProcess = remainingToProcess.substring(endOfSig);
        }
        UnresolvedType[] typeParams = new UnresolvedType[types.size()];
        types.toArray(typeParams);
        return typeParams;
    }
}

