/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.indexing;

import java.util.Locale;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.search.SearchDocument;
import org.aspectj.org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.aspectj.org.eclipse.jdt.internal.core.jdom.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.SourceIndexerRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;

public class SourceIndexer
extends AbstractIndexer
implements SuffixConstants {
    protected DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());

    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    public void indexDocument() {
        block5: {
            SourceIndexerRequestor requestor = new SourceIndexerRequestor(this);
            String documentPath = this.document.getPath();
            Path path = new Path(documentPath);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            Map options = JavaCore.create(project).getOptions(true);
            options.put("org.aspectj.org.eclipse.jdt.core.compiler.taskTags", "");
            SourceElementParser parser = new SourceElementParser(requestor, this.problemFactory, new CompilerOptions(options), true, true);
            parser.reportOnlyOneSyntaxError = true;
            parser.javadocParser.checkDocComment = true;
            char[] source = null;
            char[] name = null;
            try {
                source = this.document.getCharContents();
                name = documentPath.toCharArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (source == null || name == null) {
                return;
            }
            CompilationUnit compilationUnit = new CompilationUnit(source, name);
            try {
                parser.parseCompilationUnit(compilationUnit, true);
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block5;
                e.printStackTrace();
            }
        }
    }
}

