/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.aspectj.ajde.BuildConfigListener;
import org.aspectj.ajde.BuildConfigManager;
import org.aspectj.ajde.BuildListener;
import org.aspectj.ajde.BuildManager;
import org.aspectj.ajde.BuildOptionsAdapter;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.EditorAdapter;
import org.aspectj.ajde.ErrorHandler;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.internal.AspectJBuildManager;
import org.aspectj.ajde.internal.LstBuildConfigManager;
import org.aspectj.ajde.ui.IdeUIAdapter;
import org.aspectj.ajde.ui.StructureSearchManager;
import org.aspectj.ajde.ui.StructureViewManager;
import org.aspectj.ajde.ui.StructureViewNodeFactory;
import org.aspectj.asm.AsmManager;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.util.LangUtil;
import org.aspectj.util.Reflection;

public class Ajde {
    private static final Ajde INSTANCE = new Ajde();
    private static final String NOT_INITIALIZED_MESSAGE = "Ajde is not initialized.";
    private static boolean isInitialized = false;
    private static int compatibilityLevel = 1;
    private BuildManager buildManager;
    private EditorAdapter editorAdapter;
    private StructureViewManager structureViewManager;
    private StructureSearchManager structureSearchManager;
    private BuildConfigManager configurationManager;
    private ProjectPropertiesAdapter projectProperties;
    private TaskListManager taskListManager;
    private IdeUIAdapter ideUIAdapter;
    private ErrorHandler errorHandler;
    private PrintStream logPrintStream = null;
    private IMessageHandler messageHandler = null;
    private final BuildConfigListener STRUCTURE_UPDATE_CONFIG_LISTENER = new BuildConfigListener(){

        public void currConfigChanged(String configFilePath) {
            if (configFilePath != null) {
                Ajde.getDefault().getStructureModelManager().readStructureModel(configFilePath);
            }
        }

        public void configsListUpdated(List configsList) {
        }
    };
    private final BuildListener BUILD_STATUS_LISTENER = new BuildListener(){

        public void compileStarted(String buildConfig) {
            String configFilePath = Ajde.this.projectProperties.getDefaultBuildConfigFile();
            if (buildConfig.equals(configFilePath)) {
                Ajde.this.configurationManager.writePaths(configFilePath, Ajde.this.projectProperties.getProjectSourceFiles());
                Ajde.this.logEvent("wrote default build config: " + configFilePath);
            }
        }

        public void compileFinished(String buildConfig, int buildTime, boolean succeeded, boolean warnings) {
            if (!succeeded) {
                AsmManager.getDefault().fireModelUpdated();
            }
        }

        public void compileAborted(String buildConfigFile, String message) {
        }
    };

    protected Ajde() {
        this.configurationManager = new LstBuildConfigManager();
    }

    public static void init(EditorAdapter editorAdapter, TaskListManager taskListManager, BuildProgressMonitor compileProgressMonitor, ProjectPropertiesAdapter projectProperties, BuildOptionsAdapter buildOptionsAdapter, StructureViewNodeFactory structureViewNodeFactory, IdeUIAdapter ideUIAdapter, ErrorHandler errorHandler) {
        try {
            Ajde.INSTANCE.projectProperties = projectProperties;
            Ajde.INSTANCE.errorHandler = errorHandler;
            Ajde.INSTANCE.taskListManager = taskListManager;
            Ajde.INSTANCE.editorAdapter = editorAdapter;
            Ajde.INSTANCE.buildManager = new AspectJBuildManager(taskListManager, compileProgressMonitor, buildOptionsAdapter);
            Ajde.INSTANCE.buildManager.addListener(Ajde.INSTANCE.BUILD_STATUS_LISTENER);
            Ajde.INSTANCE.configurationManager.addListener(Ajde.INSTANCE.STRUCTURE_UPDATE_CONFIG_LISTENER);
            Ajde.INSTANCE.ideUIAdapter = ideUIAdapter;
            Ajde.INSTANCE.structureSearchManager = new StructureSearchManager();
            Ajde.INSTANCE.structureViewManager = new StructureViewManager(structureViewNodeFactory);
            isInitialized = true;
        }
        catch (Throwable t) {
            System.err.println("AJDE ERROR: could not initialize Ajde.");
            t.printStackTrace();
        }
    }

    public static Ajde getDefault() {
        if (!isInitialized) {
            throw new RuntimeException(NOT_INITIALIZED_MESSAGE);
        }
        return INSTANCE;
    }

    public void setConfigurationManager(BuildConfigManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setMessageHandler(IMessageHandler aHandler) {
        this.messageHandler = aHandler;
    }

    public IMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public BuildManager getBuildManager() {
        return this.buildManager;
    }

    public EditorAdapter getEditorAdapter() {
        return this.editorAdapter;
    }

    public StructureViewManager getStructureViewManager() {
        return this.structureViewManager;
    }

    public StructureSearchManager getStructureSearchManager() {
        return this.structureSearchManager;
    }

    public BuildConfigManager getConfigurationManager() {
        return this.configurationManager;
    }

    public ProjectPropertiesAdapter getProjectProperties() {
        return this.projectProperties;
    }

    public TaskListManager getTaskListManager() {
        return this.taskListManager;
    }

    public IdeUIAdapter getIdeUIAdapter() {
        return this.ideUIAdapter;
    }

    public void setIdeUIAdapter(IdeUIAdapter ideUIAdapter) {
        this.ideUIAdapter = ideUIAdapter;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public String getVersion() {
        return "1.5.2a";
    }

    public void enableLogging(PrintStream logPrintStream) {
        this.logPrintStream = logPrintStream;
    }

    public void disableLogging() {
        this.logPrintStream = null;
    }

    public boolean isLogging() {
        return this.logPrintStream != null;
    }

    public AsmManager getStructureModelManager() {
        return AsmManager.getDefault();
    }

    public void logEvent(String message) {
        if (this.logPrintStream != null) {
            this.logPrintStream.println("<AJDE> " + message);
        }
    }

    public Thread runInSameVM() {
        final RunProperties props = new RunProperties(this.getProjectProperties(), this.getErrorHandler());
        if (!props.valid) {
            return null;
        }
        Runnable runner = new Runnable(){

            public void run() {
                try {
                    Reflection.runMainInSameVM(props.classpath, props.mainClass, props.args);
                }
                catch (Throwable e) {
                    Ajde.getDefault().getErrorHandler().handleError("Error running " + props.mainClass, e);
                }
            }
        };
        Thread result = new Thread(runner, props.mainClass);
        result.start();
        return result;
    }

    public LangUtil.ProcessController runInNewVM() {
        final RunProperties props = new RunProperties(this.getProjectProperties(), this.getErrorHandler());
        if (!props.valid) {
            return null;
        }
        final StringBuffer command = new StringBuffer();
        LangUtil.ProcessController controller = new LangUtil.ProcessController(){

            public void doCompleting(Throwable thrown, int result) {
                String m;
                LangUtil.ProcessController.Thrown any = this.getThrown();
                if (!any.thrown && null == thrown && 0 == result) {
                    return;
                }
                String context = props.mainClass + " command \"" + command + "\"";
                if (null != thrown) {
                    m = "Exception running " + context;
                    Ajde.this.getErrorHandler().handleError(m, thrown);
                } else if (0 != result) {
                    m = "Result of running " + context;
                    Ajde.this.getErrorHandler().handleError(m + ": " + result);
                }
                if (null != any.fromInPipe) {
                    m = "Error processing input pipe for " + context;
                    Ajde.this.getErrorHandler().handleError(m, any.fromInPipe);
                }
                if (null != any.fromOutPipe) {
                    m = "Error processing output pipe for " + context;
                    Ajde.this.getErrorHandler().handleError(m, any.fromOutPipe);
                }
                if (null != any.fromErrPipe) {
                    m = "Error processing error pipe for " + context;
                    Ajde.this.getErrorHandler().handleError(m, any.fromErrPipe);
                }
            }
        };
        controller = LangUtil.makeProcess(controller, props.classpath, props.mainClass, props.args);
        command.append(Arrays.asList(controller.getCommand()).toString());
        controller.start();
        return controller;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private static class RunProperties {
        final String mainClass;
        final String classpath;
        final String[] args;
        final boolean valid;

        RunProperties(ProjectPropertiesAdapter project, ErrorHandler handler) {
            LangUtil.throwIaxIfNull(project, "project");
            LangUtil.throwIaxIfNull(handler, "handler");
            String mainClass = null;
            String classpath = null;
            String[] args = null;
            boolean valid = false;
            mainClass = project.getClassToExecute();
            if (LangUtil.isEmpty(mainClass)) {
                handler.handleWarning("No main class specified");
            } else {
                classpath = LangUtil.makeClasspath(project.getBootClasspath(), project.getClasspath(), project.getOutputPath(), project.getOutJar());
                if (LangUtil.isEmpty(classpath)) {
                    handler.handleWarning("No classpath specified");
                } else {
                    args = LangUtil.split(project.getExecutionArgs());
                    valid = true;
                }
            }
            this.mainClass = mainClass;
            this.classpath = classpath;
            this.args = args;
            this.valid = valid;
        }
    }
}

